package com.zehong.web.controller.workOrder;

import java.util.List;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.form.TWorkOrderForm;
import com.zehong.system.domain.vo.WorkOrderVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.service.ITWorkOrderService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 工单基础信息Controller
 * 
 * @author zehong
 * @date 2021-07-19
 */
@RestController
@RequestMapping("/workOrder/basicsInfo")
public class TWorkOrderController extends BaseController
{
    @Autowired
    private ITWorkOrderService tWorkOrderService;

    /**
     * 查询工单基础信息列表
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(TWorkOrderForm tWorkOrderForm) throws Exception
    {
        startPage();
        List<WorkOrderVo> list = null;
        try {
            list = tWorkOrderService.selectTWorkOrderList(tWorkOrderForm);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("查询工单基础信息列表失败");
        }
        return getDataTable(list);
    }

    /**
     * 导出工单基础信息列表
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:export')")
    @Log(title = "工单基础信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkOrderForm tWorkOrderForm) throws Exception
    {
        List<WorkOrderVo> list = null;
        try {
            list = tWorkOrderService.selectTWorkOrderList(tWorkOrderForm);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("导出工单基础信息列表失败");
        }
        ExcelUtil<WorkOrderVo> util = new ExcelUtil<WorkOrderVo>(WorkOrderVo.class);
        return util.exportExcel(list, "工单基础信息数据");
    }

    /**
     * 获取工单基础信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:query')")
    @GetMapping(value = "/{orderId}")
    public AjaxResult getInfo(@PathVariable("orderId") String orderId) throws Exception
    {
        WorkOrderVo workOrderVo = new WorkOrderVo();
        try {
            workOrderVo = tWorkOrderService.selectTWorkOrderById(orderId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取工单详细信息失败");
        }
        return AjaxResult.success(workOrderVo);
    }

    /**
     * 新增工单基础信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:add')")
    @Log(title = "工单基础信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkOrder tWorkOrder) throws Exception
    {
        String orderId = null;
        try {
            orderId = tWorkOrderService.insertTWorkOrder(tWorkOrder);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("新增工单信息失败");
        }
        return AjaxResult.success(orderId);
    }

    /**
     * 修改工单基础信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:edit')")
    @Log(title = "工单基础信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkOrder tWorkOrder) throws Exception
    {
        String orderStatus = tWorkOrder.getOrderStatus();
        // 工单状态只有是0未接收才允许修改
        if(!"0".equals(orderStatus)){
            throw new Exception("当前状态不允许修改");
        }

        try {
            tWorkOrderService.updateTWorkOrder(tWorkOrder);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("修改工单信息失败");
        }
        return AjaxResult.success();
    }

    /**
     * 修改工单状态
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:editStatus')")
    @Log(title = "工单基础信息", businessType = BusinessType.UPDATE)
    @PutMapping("/editStatus")
    public AjaxResult editStatus(@RequestBody TWorkOrder tWorkOrder) throws Exception
    {
        String orderStatus = tWorkOrder.getOrderStatus();
        if("0".equals(orderStatus)){
            tWorkOrder.setOrderStatus("1");
            tWorkOrder.setActualTime(DateUtils.getNowDate());
        } else if("1".equals(orderStatus)) {
            tWorkOrder.setOrderStatus("2");
        } else if("2".equals(orderStatus)) {
            tWorkOrder.setOrderStatus("3");
        } else if("3".equals(orderStatus)) {
            throw new Exception("当前工单已归档，不允许更改状态");
        }

        try {
            tWorkOrderService.updateTWorkOrder(tWorkOrder);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("修改工单状态失败");
        }
        return AjaxResult.success();
    }

    /**
     * 删除工单基础信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:basicsInfo:remove')")
    @Log(title = "工单基础信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{orderIds}")
    public AjaxResult remove(@PathVariable String[] orderIds)
    {
        return toAjax(tWorkOrderService.deleteTWorkOrderByIds(orderIds));
    }
}
