package com.zehong.system.domain.form;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 报警信息对象 t_device_alarm
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class DeviceAlarmForm extends BaseEntity
{
    /** 设备编号 */
    private String deviceCode;

    /** 管道编号 */
    private String pipeCode;

    /** 报警类型 */
    private String alarmType;

    /** 报警开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime1;

    /** 报警结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime1;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    private String dealStatus;

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public String getPipeCode() {
        return pipeCode;
    }

    public void setPipeCode(String pipeCode) {
        this.pipeCode = pipeCode;
    }

    public void setAlarmType(String alarmType)
    {
        this.alarmType = alarmType;
    }

    public String getAlarmType() 
    {
        return alarmType;
    }

    public void setStartTime1(Date startTime1)
    {
        this.startTime1 = startTime1;
    }

    public Date getStartTime1()
    {
        return startTime1;
    }

    public void setEndTime1(Date endTime1)
    {
        this.endTime1 = endTime1;
    }

    public Date getEndTime1()
    {
        return endTime1;
    }

    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }

}
