package com.zehong.system.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.TreeSelect;
import com.zehong.common.core.domain.entity.SysDept;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 设备信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-09
 */
@Service
public class TDeviceInfoServiceImpl implements ITDeviceInfoService 
{
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备信息
     * 
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    @Override
    public TDeviceInfo selectTDeviceInfoById(int deviceId)
    {
        return tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
    }

    /**
     * 查询设备信息列表
     * 
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);
    }

    /**
     * 构建前端所需要下拉树结构
     *
     * @param deviceInfoList 部门列表
     * @return 下拉树结构列表
     */
    @Override
    public List<Map<Object, Object>> buildDeviceTreeSelect(List<TDeviceInfo> deviceInfoList)
    {
        List<Map<Object, Object>> list = new ArrayList<>();

        for (TDeviceInfo deviceInfo : deviceInfoList) {
            Map<Object, Object> map = new HashMap<>();
            map.put("id", deviceInfo.getDeviceId());
            map.put("label", deviceInfo.getDeviceName());

            list.add(map);
        }

        return list;
    }

    /**
     * 统计各设备类型的设备总数
     * @return
     */
    public List<Map<Object, Object>> countDeviceByType(){
        return tDeviceInfoMapper.countDeviceByType();
    };

    /**
     * 新增设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.insertTDeviceInfo(tDeviceInfo);
    }

    /**
     * 修改设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.updateTDeviceInfo(tDeviceInfo);
    }

    /**
     * 批量删除设备信息
     * 
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoByIds(int[] deviceIds)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoByIds(deviceIds);
    }

    /**
     * 删除设备信息信息
     * 
     * @param deviceId 设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoById(int deviceId)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoById(deviceId);
    }
}
