package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInspectionData;

/**
 * 巡检记录Mapper接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface TInspectionDataMapper 
{
    /**
     * 查询巡检记录
     * 
     * @param dataId 巡检记录ID
     * @return 巡检记录
     */
    public TInspectionData selectTInspectionDataById(int dataId);

    /**
     * 查询巡检记录
     *
     * @param deviceCode 设备编号
     * @return 巡检记录
     */
    public TInspectionData selectTInspectionDataByCode(String deviceCode);

    /**
     * 查询巡检记录
     *
     * @param planId 巡检计划ID
     * @return 完成的巡检记录数量
     */
    public int selectFinishTInspectionData(int planId);

    /**
     * 查询巡检记录列表
     * 
     * @param tInspectionData 巡检记录
     * @return 巡检记录集合
     */
    public List<TInspectionData> selectTInspectionDataList(TInspectionData tInspectionData);

    /**
     * 新增巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    public int insertTInspectionData(TInspectionData tInspectionData);

    /**
     * 修改巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    public int updateTInspectionData(TInspectionData tInspectionData);

    /**
     * 删除巡检记录
     * 
     * @param dataId 巡检记录ID
     * @return 结果
     */
    public int deleteTInspectionDataById(int dataId);

    /**
     * 批量删除巡检记录
     * 
     * @param dataIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInspectionDataByIds(int[] dataIds);
}
