package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 工单反馈信息对象 t_order_feedback
 * 
 * @author zehong
 * @date 2021-07-19
 */
public class TOrderFeedback extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工单反馈id */
    private int feedbackId;

    /** 工单id */
    @Excel(name = "工单id")
    private String orderId;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 反馈内容 */
    @Excel(name = "反馈内容")
    private String contents;

    /** 反馈时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "反馈时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date feedbackTime;

    /** 是否存在隐患（1是，2否） */
    @Excel(name = "是否存在隐患", readConverterExp = "0=正常，1存在隐患")
    private String isHiddenDanger;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1=不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 图片地址1 */
    @Excel(name = "图片地址1")
    private String pictureUrl1;

    /** 图片地址2 */
    @Excel(name = "图片地址2")
    private String pictureUrl2;

    /** 图片地址3 */
    @Excel(name = "图片地址3")
    private String pictureUrl3;

    public void setFeedbackId(int feedbackId)
    {
        this.feedbackId = feedbackId;
    }

    public int getFeedbackId()
    {
        return feedbackId;
    }
    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode()
    {
        return deviceCode;
    }
    public void setContents(String contents) 
    {
        this.contents = contents;
    }

    public String getContents() 
    {
        return contents;
    }
    public void setFeedbackTime(Date feedbackTime) 
    {
        this.feedbackTime = feedbackTime;
    }

    public Date getFeedbackTime() 
    {
        return feedbackTime;
    }
    public void setIsHiddenDanger(String isHiddenDanger) 
    {
        this.isHiddenDanger = isHiddenDanger;
    }

    public String getIsHiddenDanger() 
    {
        return isHiddenDanger;
    }
    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setPictureUrl1(String pictureUrl1) 
    {
        this.pictureUrl1 = pictureUrl1;
    }

    public String getPictureUrl1() 
    {
        return pictureUrl1;
    }
    public void setPictureUrl2(String pictureUrl2) 
    {
        this.pictureUrl2 = pictureUrl2;
    }

    public String getPictureUrl2() 
    {
        return pictureUrl2;
    }
    public void setPictureUrl3(String pictureUrl3) 
    {
        this.pictureUrl3 = pictureUrl3;
    }

    public String getPictureUrl3() 
    {
        return pictureUrl3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("feedbackId", getFeedbackId())
            .append("orderId", getOrderId())
            .append("deviceId", getDeviceCode())
            .append("contents", getContents())
            .append("feedbackTime", getFeedbackTime())
            .append("isHiddenDanger", getIsHiddenDanger())
            .append("dealStatus", getDealStatus())
            .append("pictureUrl1", getPictureUrl1())
            .append("pictureUrl2", getPictureUrl2())
            .append("pictureUrl3", getPictureUrl3())
            .toString();
    }
}
