package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.*;
import com.zehong.system.domain.vo.WorkOrderVo;
import com.zehong.system.mapper.*;
import com.zehong.system.service.ITInspectionPlanService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.service.ITWorkOrderService;

/**
 * 工单基础信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-19
 */
@Service
public class TWorkOrderServiceImpl implements ITWorkOrderService 
{
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;
    @Autowired
    private TOrderFeedbackMapper tOrderFeedbackMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private TInspectionPlanMapper tInspectionPlanMapper;
    @Autowired
    private TInspectionDataMapper tInspectionDataMapper;
    @Autowired
    private THiddenTroubleMapper tHiddenTroubleMapper;
    @Autowired
    private TDeviceAlarmMapper tDeviceAlarmMapper;
    @Autowired
    private TPipeMapper tPipeMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    @Autowired
    private ITInspectionPlanService tInspectionPlanService;

    /**
     * 查询工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 工单基础信息
     */
    @Override
    public WorkOrderVo selectTWorkOrderById(String orderId) throws Exception
    {
        WorkOrderVo workOrderVo = new WorkOrderVo();
        TWorkOrder tWorkOrder = tWorkOrderMapper.selectTWorkOrderById(orderId);

        BeanUtils.copyProperties(tWorkOrder, workOrderVo);

        // 获取巡检员姓名
        SysUser appointInspector = sysUserMapper.selectUserById(tWorkOrder.getAppointInspector());
        workOrderVo.setAppointInspectorName(appointInspector.getNickName());

        if(tWorkOrder.getActualInspector() != tWorkOrder.getAppointInspector() && tWorkOrder.getActualInspector() != null){
            SysUser actualInspector = sysUserMapper.selectUserById(tWorkOrder.getActualInspector());
            workOrderVo.setActualInspectorName(actualInspector.getNickName());
        } else {
            workOrderVo.setActualInspectorName(appointInspector.getNickName());
        }

        // 获取源数据(1巡检信息，2隐患信息，3报警信息)
        String orderType = tWorkOrder.getOrderType();
        int resourceId = tWorkOrder.getResourceId();
        if("1".equals(orderType)){

            TInspectionPlan plan = tInspectionPlanMapper.selectTInspectionPlanById(resourceId);
            workOrderVo.setDeviceCodes(plan.getDeviceCodes());

            TInspectionData data = new TInspectionData();
            data.setPlanId(resourceId);

            List<TInspectionData> totalList = tInspectionDataMapper.selectTInspectionDataList(data);
            workOrderVo.setDeviceNum(totalList.size());

            List<TDeviceInfo> deviceInfoList = new ArrayList<>();
            TDeviceInfo deviceInfo = null;

            for(TInspectionData temp : totalList){
                deviceInfo = tDeviceInfoMapper.selectTDeviceInfoByCode(temp.getDeviceCode());
                if(deviceInfo != null){
                    deviceInfoList.add(deviceInfo);
                }
            }
            workOrderVo.setDeviceInfoList(deviceInfoList);

            int finish = tInspectionDataMapper.selectFinishTInspectionData(resourceId);
            workOrderVo.setFinishNum(finish);

        } else if("2".equals(orderType)){

            THiddenTrouble trouble = tHiddenTroubleMapper.selectTHiddenTroubleById(resourceId);
            workOrderVo.setDeviceCodes((trouble.getDeviceCode() != null ? trouble.getDeviceCode() : null).toString());
            workOrderVo.setLongitude(trouble.getLongitude() != null ? trouble.getLongitude() : null);
            workOrderVo.setLatitude(trouble.getLatitude() != null ? trouble.getLatitude() : null);
            workOrderVo.setCoordinates(trouble.getCoordinates() != null ? trouble.getCoordinates() : null);
            workOrderVo.setDeviceType(trouble.getDeviceType());

        } else {

            TDeviceAlarm alarm = tDeviceAlarmMapper.selectTDeviceAlarmById(resourceId);
            String deviceCode = alarm.getDeviceCode();
            workOrderVo.setDeviceCodes(String.valueOf(deviceCode));

            String isPipe = alarm.getIsPipe();
            if("0".equals(isPipe)){
                TPipe pipe = tPipeMapper.selectTPipeByCode(deviceCode);
                workOrderVo.setCoordinates(pipe.getCoordinates());
                workOrderVo.setDeviceType("0");
            } else {
                TDeviceInfo device = tDeviceInfoMapper.selectTDeviceInfoByCode(deviceCode);
                workOrderVo.setLongitude(device.getLongitude());
                workOrderVo.setLatitude(device.getLatitude());
                workOrderVo.setDeviceType(device.getDeviceType());
            }
        }

        List<TOrderFeedback> feedbackList = tOrderFeedbackMapper.selectTOrderFeedbackByOrderId(tWorkOrder.getOrderId());
        if(feedbackList.size() != 0){
            TOrderFeedback feedback = feedbackList.get(0);
            workOrderVo.setContents(feedback.getContents());
            workOrderVo.setFeedbackTime(feedback.getFeedbackTime());
            workOrderVo.setDealStatus(feedback.getDealStatus());
        }

        return workOrderVo;
    }

    /**
     * 查询工单基础信息列表
     * 
     * @param tWorkOrder 工单基础信息
     * @return 工单基础信息
     */
    @Override
    public List<WorkOrderVo> selectTWorkOrderList(TWorkOrder tWorkOrder) throws Exception
    {
        List<WorkOrderVo> workOrderVoList = new ArrayList<WorkOrderVo>();
        List<TWorkOrder> workOrderList = tWorkOrderMapper.selectTWorkOrderList(tWorkOrder);

        if(workOrderList.size() != 0){

            for(TWorkOrder workOrder : workOrderList){
                WorkOrderVo workOrderVo = new WorkOrderVo();
                BeanUtils.copyProperties(workOrder, workOrderVo);

                // 获取巡检员姓名
                SysUser appointInspector = sysUserMapper.selectUserById(workOrder.getAppointInspector());
                workOrderVo.setAppointInspectorName(appointInspector.getNickName());

                if(workOrder.getActualInspector() != workOrder.getAppointInspector() && workOrder.getActualInspector() != null){
                    SysUser actualInspector = sysUserMapper.selectUserById(tWorkOrder.getActualInspector());
                    workOrderVo.setActualInspectorName(actualInspector.getNickName());
                } else {
                    workOrderVo.setActualInspectorName(appointInspector.getNickName());
                }

                workOrderVoList.add(workOrderVo);
            }
        }
        return workOrderVoList;
    }

    /**
     * 新增工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int insertTWorkOrder(TWorkOrder tWorkOrder) throws Exception
    {
        String orderId = tWorkOrderMapper.getWorkOrderId();
        tWorkOrder.setOrderId(orderId);
        tWorkOrder.setOrderStatus("0");
        tWorkOrder.setAllotTime(DateUtils.getNowDate());

        int planId = tWorkOrder.getResourceId();
        // 修改巡检计划状态为已下发
        TInspectionPlan plan = new TInspectionPlan();
        plan.setPlanId(planId);
        plan.setPlanStatus("1");
        tInspectionPlanService.updateTInspectionPlan(plan);

        return tWorkOrderMapper.insertTWorkOrder(tWorkOrder);
    }

    /**
     * 修改工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int updateTWorkOrder(TWorkOrder tWorkOrder) throws Exception
    {
        if("1".equals(tWorkOrder.getOrderStatus())){

            TWorkOrder order = tWorkOrderMapper.selectTWorkOrderById(tWorkOrder.getOrderId());
            int planId = order.getResourceId();
            // 修改巡检计划状态为进行中
            TInspectionPlan plan = new TInspectionPlan();
            plan.setPlanId(planId);
            plan.setPlanStatus("2");
            tInspectionPlanService.updateTInspectionPlan(plan);

        } else if ("4".equals(tWorkOrder.getOrderStatus())){

            TWorkOrder order = tWorkOrderMapper.selectTWorkOrderById(tWorkOrder.getOrderId());
            int planId = order.getResourceId();
            // 修改巡检计划状态为已完成
            TInspectionPlan plan = new TInspectionPlan();
            plan.setPlanId(planId);
            plan.setPlanStatus("3");
            tInspectionPlanService.updateTInspectionPlan(plan);

        }
        tWorkOrder.setUpdateTime(DateUtils.getNowDate());
        return tWorkOrderMapper.updateTWorkOrder(tWorkOrder);
    }

    /**
     * 批量删除工单基础信息
     * 
     * @param orderIds 需要删除的工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderByIds(String[] orderIds)
    {
        return tWorkOrderMapper.deleteTWorkOrderByIds(orderIds);
    }

    /**
     * 删除工单基础信息信息
     * 
     * @param orderId 工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderById(String orderId)
    {
        return tWorkOrderMapper.deleteTWorkOrderById(orderId);
    }
}
