package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 工单基础信息对象 t_work_order
 * 
 * @author zehong
 * @date 2021-07-19
 */
public class WorkOrderVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工单id */
    private String orderId;

    /** 工单类型（1巡检信息，2隐患信息，3报警信息） */
    private String orderType;

    /** 源id */
    private int resourceId;

    /** 工单名称 */
    private String orderName;

    /** 设备编号 */
    private String deviceCodes;

    /** 设备列表 */
    private List<TDeviceInfo> deviceInfoList;

    /** 设备数量 */
    private int deviceNum;

    /** 完成数量 */
    private int finishNum;

    /** 设备类型 */
    private String deviceType;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 坐标 */
    private String coordinates;

    /** 工单状态（0未接收，1已接收，2进行中，3已反馈，4已归档） */
    private String orderStatus;

    /** 指定执行人员（巡检员id） */
    private Long appointInspector;

    /** 指定执行人员姓名 */
    private String appointInspectorName;

    /** 下发时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date allotTime;

    /** 实际接收人员（巡检员id） */
    private Long actualInspector;

    /** 实际接收人员姓名 */
    private String actualInspectorName;

    /** 实际接收时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualTime;

    /** 备注 */
    private String remarks;

    /** 反馈内容 */
    private String contents;

    /** 反馈时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date feedbackTime;

    /** 处理状态 */
    private String dealStatus;

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }

    public int getResourceId() {
        return resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public void setOrderName(String orderName)
    {
        this.orderName = orderName;
    }

    public String getOrderName() 
    {
        return orderName;
    }

    public String getDeviceCodes() {
        return deviceCodes;
    }

    public void setDeviceCodes(String deviceCodes) {
        this.deviceCodes = deviceCodes;
    }

    public List<TDeviceInfo> getDeviceInfoList() {
        return deviceInfoList;
    }

    public void setDeviceInfoList(List<TDeviceInfo> deviceInfoList) {
        this.deviceInfoList = deviceInfoList;
    }

    public int getDeviceNum() {
        return deviceNum;
    }

    public void setDeviceNum(int deviceNum) {
        this.deviceNum = deviceNum;
    }

    public int getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(int finishNum) {
        this.finishNum = finishNum;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public void setOrderStatus(String orderStatus)
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }
    public void setAppointInspector(Long appointInspector)
    {
        this.appointInspector = appointInspector;
    }

    public Long getAppointInspector()
    {
        return appointInspector;
    }
    public void setAllotTime(Date allotTime) 
    {
        this.allotTime = allotTime;
    }

    public Date getAllotTime() 
    {
        return allotTime;
    }
    public void setActualInspector(Long actualInspector)
    {
        this.actualInspector = actualInspector;
    }

    public Long getActualInspector()
    {
        return actualInspector;
    }
    public void setActualTime(Date actualTime) 
    {
        this.actualTime = actualTime;
    }

    public Date getActualTime() 
    {
        return actualTime;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getAppointInspectorName() {
        return appointInspectorName;
    }

    public void setAppointInspectorName(String appointInspectorName) {
        this.appointInspectorName = appointInspectorName;
    }

    public String getActualInspectorName() {
        return actualInspectorName;
    }

    public void setActualInspectorName(String actualInspectorName) {
        this.actualInspectorName = actualInspectorName;
    }

    public String getContents() {
        return contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public Date getFeedbackTime() {
        return feedbackTime;
    }

    public void setFeedbackTime(Date feedbackTime) {
        this.feedbackTime = feedbackTime;
    }

    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("orderId", getOrderId())
            .append("orderType", getOrderType())
            .append("resourceId", getResourceId())
            .append("orderName", getOrderName())
            .append("deviceCodes", getDeviceCodes())
            .append("deviceNum", getDeviceNum())
            .append("finishNum", getFinishNum())
            .append("deviceType", getDeviceType())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("coordinates", getCoordinates())
            .append("orderStatus", getOrderStatus())
            .append("createTime", getCreateTime())
            .append("appointInspector", getAppointInspector())
            .append("appointInspectorName", getAppointInspectorName())
            .append("allotTime", getAllotTime())
            .append("actualInspector", getActualInspector())
            .append("actualInspectorName", getActualInspectorName())
            .append("actualTime", getActualTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
