package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TVideoManagerMapper;
import com.zehong.system.domain.TVideoManager;
import com.zehong.system.service.ITVideoManagerService;

/**
 * 视频管理Service业务层处理
 * 
 * @author zehong
 * @date 2021-09-18
 */
@Service
public class TVideoManagerServiceImpl implements ITVideoManagerService 
{
    @Autowired
    private TVideoManagerMapper tVideoManagerMapper;

    /**
     * 查询视频管理
     * 
     * @param videoManagerId 视频管理ID
     * @return 视频管理
     */
    @Override
    public TVideoManager selectTVideoManagerById(String videoManagerId)
    {
        return tVideoManagerMapper.selectTVideoManagerById(videoManagerId);
    }

    /**
     * 查询视频管理列表
     * 
     * @param tVideoManager 视频管理
     * @return 视频管理
     */
    @Override
    public List<TVideoManager> selectTVideoManagerList(TVideoManager tVideoManager)
    {
        return tVideoManagerMapper.selectTVideoManagerList(tVideoManager);
    }

    /**
     * 新增视频管理
     * 
     * @param tVideoManager 视频管理
     * @return 结果
     */
    @Override
    public int insertTVideoManager(TVideoManager tVideoManager)
    {
        return tVideoManagerMapper.insertTVideoManager(tVideoManager);
    }

    /**
     * 修改视频管理
     * 
     * @param tVideoManager 视频管理
     * @return 结果
     */
    @Override
    public int updateTVideoManager(TVideoManager tVideoManager)
    {
        return tVideoManagerMapper.updateTVideoManager(tVideoManager);
    }

    /**
     * 批量删除视频管理
     * 
     * @param videoManagerIds 需要删除的视频管理ID
     * @return 结果
     */
    @Override
    public int deleteTVideoManagerByIds(String[] videoManagerIds)
    {
        return tVideoManagerMapper.deleteTVideoManagerByIds(videoManagerIds);
    }

    /**
     * 删除视频管理信息
     * 
     * @param videoManagerId 视频管理ID
     * @return 结果
     */
    @Override
    public int deleteTVideoManagerById(String videoManagerId)
    {
        return tVideoManagerMapper.deleteTVideoManagerById(videoManagerId);
    }
}
