package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUserLocationMapper;
import com.zehong.system.domain.TUserLocation;
import com.zehong.system.service.ITUserLocationService;

/**
 * 巡检员定位Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-31
 */
@Service
public class TUserLocationServiceImpl implements ITUserLocationService 
{
    @Autowired
    private TUserLocationMapper tUserLocationMapper;

    /**
     * 查询巡检员定位
     * 
     * @param locationId 巡检员定位ID
     * @return 巡检员定位
     */
    @Override
    public TUserLocation selectTUserLocationById(Long locationId)
    {
        return tUserLocationMapper.selectTUserLocationById(locationId);
    }

    /**
     * 查询巡检员定位列表
     * 
     * @param tUserLocation 巡检员定位
     * @return 巡检员定位
     */
    @Override
    public List<TUserLocation> selectTUserLocationList(TUserLocation tUserLocation)
    {
        return tUserLocationMapper.selectTUserLocationList(tUserLocation);
    }

    @Override
    public List<TUserLocation> selectTUserLocationListByMap(Map<String,Object> map){
        return tUserLocationMapper.selectTUserLocationListByMap(map);
    }

    /**
     * 新增巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    @Override
    public int insertTUserLocation(TUserLocation tUserLocation)
    {
        tUserLocation.setCreateTime(DateUtils.getNowDate());
        return tUserLocationMapper.insertTUserLocation(tUserLocation);
    }
    @Override
    public int addTUserLocationList(String tUserLocationList){
        List<TUserLocation> list =(List<TUserLocation> )JSONObject.parse(tUserLocationList);
        return tUserLocationMapper.insertTUserLocationList(list);
    }
    /**
     * 修改巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    @Override
    public int updateTUserLocation(TUserLocation tUserLocation)
    {
        return tUserLocationMapper.updateTUserLocation(tUserLocation);
    }

    /**
     * 批量删除巡检员定位
     * 
     * @param locationIds 需要删除的巡检员定位ID
     * @return 结果
     */
    @Override
    public int deleteTUserLocationByIds(Long[] locationIds)
    {
        return tUserLocationMapper.deleteTUserLocationByIds(locationIds);
    }

    /**
     * 删除巡检员定位信息
     * 
     * @param locationId 巡检员定位ID
     * @return 结果
     */
    @Override
    public int deleteTUserLocationById(Long locationId)
    {
        return tUserLocationMapper.deleteTUserLocationById(locationId);
    }
}
