package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.zehong.common.utils.PageInfoUtil;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TPipe;
import com.zehong.system.domain.vo.DeviceInfoVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.mapper.TPipeMapper;
import com.zehong.system.service.ITDeviceInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备信息Service业务层处理
 *
 * @author zehong
 * @date 2021-07-09
 */
@Service
public class TDeviceInfoServiceImpl implements ITDeviceInfoService
{
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    @Autowired
    private TPipeMapper tPipeMapper;

    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    @Override
    public DeviceInfoVo selectTDeviceInfoById(int deviceId)
    {
        DeviceInfoVo deviceInfoVo = new DeviceInfoVo();
        TDeviceInfo tDeviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
        BeanUtils.copyProperties(tDeviceInfo, deviceInfoVo);

        TPipe pipe = tPipeMapper.selectTPipeById(tDeviceInfo.getPipeId());
        deviceInfoVo.setPipeName(pipe.getPipeName());

        return deviceInfoVo;
    }

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public List<DeviceInfoVo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo)
    {
        List<DeviceInfoVo> list = new ArrayList<>();
        List<TDeviceInfo> deviceInfoList = tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);

        if(deviceInfoList.size() != 0){

            for(TDeviceInfo device : deviceInfoList){
                DeviceInfoVo deviceInfoVo = new DeviceInfoVo();
                BeanUtils.copyProperties(device, deviceInfoVo);

                TPipe pipe = tPipeMapper.selectTPipeById(device.getPipeId());
                deviceInfoVo.setPipeName(pipe.getPipeName());

                list.add(deviceInfoVo);
            }
        }

        return list;
    }

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public PageInfo<DeviceInfoVo> selectTDeviceInfoPage(TDeviceInfo tDeviceInfo)
    {
        List<TDeviceInfo> deviceInfoList = tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);
        PageInfo<DeviceInfoVo> pageVo = PageInfoUtil.pageInfo2PageInfoDTO(new PageInfo(deviceInfoList),DeviceInfoVo.class);
        if(pageVo.getList().size() != 0){
            for(DeviceInfoVo device : pageVo.getList()){

                TPipe pipe = tPipeMapper.selectTPipeById(device.getPipeId());
                device.setPipeName(pipe.getPipeName());

            }
        }

        return pageVo;
    }
    @Override
    public List<Map<String, Object>> devicefeed(Map<String, Object> param)
    {
        List<Integer> ids = new ArrayList<>();
        List<Integer> ids2 = new ArrayList<>();
        List<Map<Object, Object>> deviceList = (List<Map<Object, Object>>)param.get("key1");
        List<Map<Object, Object>> pipeList = (List<Map<Object, Object>>)param.get("key2");
        String orderId = (String) param.get("orderId");
        if(deviceList.size() != 0) {
            for (Map<Object, Object> temp : deviceList) {
                ids.add((Integer) temp.get("deviceId"));
            }
        }
        if(pipeList.size() != 0){
            for(Map<Object, Object> temp : pipeList){
                ids2.add((Integer) temp.get("pipeId"));
            }
        }
        List<Map<String,Object>> list = tDeviceInfoMapper.selectdevicefeed(orderId,ids,ids2);
        for(Map<String,Object> map:list){
            if((long)map.get("type")==1){
                //List<String[]> listgps =
                String str = (String) map.get("longitude");
                String[] strgps = str.split(",");
                map.put("longitude",strgps[0].substring(3, strgps[0].length() - 1));
                map.put("latitude",strgps[1].substring(1, strgps[1].length() - 2));
                //JSONObject jo =  JSONObject.parseObject(str);
            }
        }
        return list;
    }
    /**
     * 构建前端所需要下拉树结构
     *
     * @param param 参数集合
     * @return 下拉树结构列表
     */
    @Override
    public List<Map<Object, Object>> buildDeviceTreeSelect(Map<Object, List> param)
    {
        List<Map<Object, Object>> list = new ArrayList<>();
        List<Map<Object, Object>> deviceList = param.get("key1");
        List<Map<Object, Object>> pipeList = param.get("key2");

        if(deviceList.size() != 0) {
            for (Map<Object, Object> temp : deviceList) {
                Map<Object, Object> map = new HashMap<>();
                map.put("id", temp.get("deviceId"));
                map.put("label", temp.get("deviceName"));
                list.add(map);
            }
        }

        if(pipeList.size() != 0){
            for(Map<Object, Object> temp : pipeList){
                Map<Object, Object> map = new HashMap<>();
                map.put("id", temp.get("pipeId"));
                map.put("label", temp.get("pipeName"));
                list.add(map);
            }
        }

        return list;
    }

    /**
     * 设备树
     *
     * @param
     * @return 树结构列表
     */
    @Override
    public List<Map<Object, Object>> buildDeviceTree() throws Exception
    {
        List<TPipe> pipeList = tPipeMapper.selectTPipeList(new TPipe());
        List<TDeviceInfo> deviceList = tDeviceInfoMapper.selectTDeviceInfoList(new TDeviceInfo());

        List<Map<Object, Object>> treeNodeList = new ArrayList<>();

        if(pipeList.size() != 0){
            List<Map<Object, Object>> childNodeList = new ArrayList<>();

            for(TPipe pipe : pipeList){
                Map<Object, Object> map = new HashMap<>();
                map.put("id", pipe.getPipeId());
                map.put("level", "2");
                map.put("name", pipe.getPipeName());
                childNodeList.add(map);
            }

            Map<Object, Object> treeNode = new HashMap<>();
            treeNode.put("id", "0");
            treeNode.put("level", "1");
            treeNode.put("name", "管道");
            treeNode.put("childList", childNodeList);

            treeNodeList.add(treeNode);
        }

        if(deviceList.size() != 0) {
            List<Map<Object, Object>> childNodeList1 = new ArrayList<>();
            List<Map<Object, Object>> childNodeList2 = new ArrayList<>();
            List<Map<Object, Object>> childNodeList3 = new ArrayList<>();
            List<Map<Object, Object>> childNodeList4 = new ArrayList<>();

            for (TDeviceInfo device : deviceList) {

                Map<Object, Object> childNode = new HashMap<>();
                childNode.put("id", device.getDeviceId());
                childNode.put("level", 2);
                childNode.put("name", device.getDeviceName());

                if("1".equals(device.getDeviceType())) {
                    childNodeList1.add(childNode);
                } else if ("2".equals(device.getDeviceType())) {
                    childNodeList2.add(childNode);
                } else if ("3".equals(device.getDeviceType())) {
                    childNodeList3.add(childNode);
                } else if ("4".equals(device.getDeviceType())){
                    childNodeList4.add(childNode);
                }
            }

            Map<Object, Object> treeNode1 = new HashMap<>();
            treeNode1.put("id", "1");
            treeNode1.put("level", "1");
            treeNode1.put("name", "调压阀");
            treeNode1.put("childList", childNodeList1);
            Map<Object, Object> treeNode2 = new HashMap<>();
            treeNode2.put("id", "2");
            treeNode2.put("level", "1");
            treeNode2.put("name", "阀门井");
            treeNode2.put("childList", childNodeList2);
            Map<Object, Object> treeNode3 = new HashMap<>();
            treeNode3.put("id", "3");
            treeNode3.put("level", "1");
            treeNode3.put("name", "流量计");
            treeNode3.put("childList", childNodeList3);
            Map<Object, Object> treeNode4 = new HashMap<>();
            treeNode4.put("id", "4");
            treeNode4.put("level", "1");
            treeNode4.put("name", "压力表");
            treeNode4.put("childList", childNodeList4);

            treeNodeList.add(treeNode1);
            treeNodeList.add(treeNode2);
            treeNodeList.add(treeNode3);
            treeNodeList.add(treeNode4);
        }

        return treeNodeList;
    }

    /**
     * 统计各设备类型的设备总数
     * @return
     */
    public List<Map<Object, Object>> countDeviceByType(){
        return tDeviceInfoMapper.countDeviceByType();
    };

    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.insertTDeviceInfo(tDeviceInfo);
    }

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.updateTDeviceInfo(tDeviceInfo);
    }

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoByIds(int[] deviceIds)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoByIds(deviceIds);
    }

    /**
     * 删除设备信息信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoById(int deviceId)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoById(deviceId);
    }
}
