package com.zehong.system.service;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.TInspectionPlan;
import com.zehong.system.domain.form.InspectionPlanForm;
import com.zehong.system.domain.vo.InspectionPlanVo;

/**
 * 巡检计划Service接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface ITInspectionPlanService 
{
    /**
     * 查询巡检计划
     * 
     * @param planId 巡检计划ID
     * @return 巡检计划
     */
    public InspectionPlanVo selectTInspectionPlanById(int planId) throws Exception;

    /**
     * 查询巡检计划列表
     * 
     * @param inspectionPlanForm 巡检计划
     * @return 巡检计划集合
     */
    public List<TInspectionPlan> selectTInspectionPlanList(InspectionPlanForm inspectionPlanForm);

    /**
     * 查询巡检计划列表
     *
     * @param inspectionPlanForm 巡检计划
     * @return 巡检计划集合
     */
    public PageInfo<TInspectionPlan> selectTInspectionPlanPage(InspectionPlanForm inspectionPlanForm);

    /**
     * 新增巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    public int insertTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception;

    /**
     * 修改巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    public int updateTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception;

    /**
     * 批量删除巡检计划
     * 
     * @param planIds 需要删除的巡检计划ID
     * @return 结果
     */
    public int deleteTInspectionPlanByIds(int[] planIds);

    /**
     * 删除巡检计划信息
     * 
     * @param planId 巡检计划ID
     * @return 结果
     */
    public int deleteTInspectionPlanById(int planId);
}
