﻿import createPop from "./createPop";
import regulatorBoxOrValveWell from "../components/PopWindow/regulatorBoxOrValveWell.vue"
let defaultCenter = "石家庄";
export let map;
class gaodeMap {
  //构造函数中设置中央点默认值
  constructor(center) {
    this.center = center?center:defaultCenter;
    map = new AMap.Map('container', {
      //mask: addMask(result.districtList[0].boundaries),
      center: [114.72995, 38.37417],
      // resizeEnable: true,
      disableSocket: true,
      viewMode: '3D',
      showLabel: true,
      // labelzIndex: 110,
      pitch: 8,
      zoom: 9,
      //mapStyle: 'amap://styles/darkblue',
      // mapStyle: 'amap://styles/3b679a15f448a4740ba2ff7524e1a4ae',
    });
    this.districtBoundaries();
  }

  /**
   * 获取map
   * @returns {AMap.Map}
   */
  get getMap(){
    return this.map;
  }

  /**
   * 重新设置中央点
   * @param value
   */
  set setCenter(value){
    this.center = value;
    this.districtBoundaries();
  }

  /**
   * 设置城市边界
   */
  districtBoundaries(){
   let that = this;
   let opts = {
     subdistrict: 0,
     extensions: 'all',
     level: 'city'
   };
   let district = new AMap.DistrictSearch(opts);
   district.search(that.center, function (status, result) {
     if(status == "complete"){
       let defaultCenter = [];
       defaultCenter.push(result.districtList[0].center.lng);
       defaultCenter.push(result.districtList[0].center.lat);
       map.setCenter(defaultCenter);
       let  bounds =result.districtList[0].boundaries;
       for (let i = 0; i < bounds.length; i += 1) {
         new AMap.Polyline({
           path: bounds[i],
           strokeColor: '#0088ff',
           strokeWeight: 5,
           strokeOpacity: 7,
           map: map,
         });
       }
     }
   })
 }

  /**
   * 添加Market
   * @param lnglats
   */
  addMarker(lnglats){
    let infoWindow = new AMap.InfoWindow({offset: new AMap.Pixel(-13, -70)});
    for (let i = 0; i < lnglats.length; i++) {
      let marker = new AMap.Marker({
        position: lnglats[i],
        map: map,
        offset: new AMap.Pixel(-13, -30),
        // 设置是否可以拖拽
        draggable: true,
        cursor: 'move',
        // 设置拖拽效果
        raiseOnDrag: true
      });
      marker.content  = '<h4>我是第' + (i + 1) + '个XXX</h4>';
      marker.content += '<h6>经度：'+lnglats[i][0]+'</h6>';
      marker.content += '<h6>纬度：'+lnglats[i][1]+'</h6>';
      marker.content += '<button class="btn btn-success btn-xs">历史轨迹</button>';
      marker.content += '<button class="btn btn-warning btn-xs">实时跟踪 </button>';
      marker.content += '<button class="btn btn-danger btn-xs">设置</button>';

      marker.on('mouseover', infoOpen);
      //注释后打开地图时默认关闭信息窗体
      //marker.emit('mouseover', {target: marker});

      marker.on('mouseout', infoClose);
      marker.on('click', newMAp);
      marker.on('dragend', moveMarker);
    }
    map.setFitView();

    //鼠标点击事件,设置地图中心点及放大显示级别
    function newMAp(e) {
      //map.setCenter(e.target.getPosition());
      map.setZoomAndCenter(13, e.target.getPosition());
      let infoWindow = new AMap.InfoWindow({offset: new AMap.Pixel(-13, -70)});
      infoWindow.setContent(e.target.content);
      infoWindow.open(map, e.target.getPosition());
    }

    function infoClose(e) {
      infoWindow.close(map, e.target.getPosition());
    }

    function infoOpen(e) {
      infoWindow.setContent(e.target.content);
      infoWindow.open(map, e.target.getPosition());
    }

    function moveMarker(e) {
      alert(e.lnglat);
    }
  }

  /**
   * 添加折线
   * @param path
   */
  addPolyline(path){
    let polylines = [];
    for(let i = 0;i< path.length; i++){
      let polyline = new AMap.Polyline({
        path: path[i],
        strokeColor: "green",
        strokeWeight: 8,
        strokeOpacity: 0.9,
        zIndex: 50,
        bubble: true,
      })
      polylines.push(polyline);
      let polyEditor = new AMap.PolyEditor(map, polyline);
      //创建右键菜单
      let contextMenu = new AMap.ContextMenu();
      //右键放大
      contextMenu.addItem("编辑Polyline", function () {
        polyEditor.setTarget(polyline);
        polyEditor.open();
      }, 0);
      contextMenu.addItem("结束编辑", function () {
        polyEditor.close();
      }, 0);
      //添加事件
      polyline.on("rightclick",function (e) {
        contextMenu.open(map, e.lnglat);
      })
    }
    map.add(polylines);
    // 缩放地图到合适的视野级别
    map.setFitView();
  }

  /**
   * 添加鼠标事件
   */
  addMouseTool(){
    this.mouseTool = new AMap.MouseTool(map);
    //监听draw事件可获取画好的覆盖物
    this.overlays = [];
    let that = this;
    this.mouseTool.on('draw',function(e){
      e.obj.on("click",function (aa) {
        console.log(aa.target._position)
        that.openInfowindow();
      })
      that.overlays.push(e.obj);
      that.mouseTool.close();
    });
  }

  openInfowindow(){
    const notice = createPop(regulatorBoxOrValveWell, {
      title: '调压箱'
    })
    notice.show()
  }

  draw(type){
    let that = this;
    switch(type){
      case 'marker':{
        that.mouseTool.marker({
          draggable: true
        });
        break;
      }
      case 'polyline':{
        that.mouseTool.polyline({
          strokeWeight: 9,
          strokeColor:'#80d8ff'
          //同Polyline的Option设置
        });
        break;
      }
    }
  }

  /**
   * 添加地图控件
   */
  addMapControl(){
    AMap.plugin([
      'AMap.ToolBar',
      'AMap.Scale',
      'AMap.HawkEye',
      'AMap.MapType',
      'AMap.Geolocation',
    ], function(){
      // 在图面添加工具条控件，工具条控件集成了缩放、平移、定位等功能按钮在内的组合控件
      //map.addControl(new AMap.ToolBar());

      // 在图面添加比例尺控件，展示地图在当前层级和纬度下的比例尺
      map.addControl(new AMap.Scale());

      // 在图面添加鹰眼控件，在地图右下角显示地图的缩略图
      map.addControl(new AMap.HawkEye({isOpen:true}));

      // 在图面添加类别切换控件，实现默认图层与卫星图、实施交通图层之间切换的控制
      map.addControl(new AMap.MapType({position :{top: '10px',left: '100px'}}));

      // 在图面添加定位控件，用来获取和展示用户主机所在的经纬度位置
     // map.addControl(new AMap.Geolocation());
    });
  }




}
export default gaodeMap;
