package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.ExceptionUtil;
import com.zehong.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkOrderMapper;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.service.ITWorkOrderService;

/**
 * 工单基础信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-19
 */
@Service
public class TWorkOrderServiceImpl implements ITWorkOrderService 
{
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;

    /**
     * 获取工单基础信息id
     *
     * @return 工单基础信息id
     */
    @Override
    public String getWorkOrderId()
    {
        return tWorkOrderMapper.getWorkOrderId();
    }

    /**
     * 查询工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 工单基础信息
     */
    @Override
    public TWorkOrder selectTWorkOrderById(String orderId)
    {
        return tWorkOrderMapper.selectTWorkOrderById(orderId);
    }

    /**
     * 查询工单基础信息列表
     * 
     * @param tWorkOrder 工单基础信息
     * @return 工单基础信息
     */
    @Override
    public List<TWorkOrder> selectTWorkOrderList(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.selectTWorkOrderList(tWorkOrder);
    }

    /**
     * 新增工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int insertTWorkOrder(TWorkOrder tWorkOrder)
    {
        String orderId = tWorkOrderMapper.getWorkOrderId();

        tWorkOrder.setOrderId(orderId);
        tWorkOrder.setCreateTime(DateUtils.getNowDate());
        return tWorkOrderMapper.insertTWorkOrder(tWorkOrder);
    }

    /**
     * 修改工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int updateTWorkOrder(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.updateTWorkOrder(tWorkOrder);
    }

    /**
     * 批量删除工单基础信息
     * 
     * @param orderIds 需要删除的工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderByIds(String[] orderIds)
    {
        return tWorkOrderMapper.deleteTWorkOrderByIds(orderIds);
    }

    /**
     * 删除工单基础信息信息
     * 
     * @param orderId 工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderById(String orderId)
    {
        return tWorkOrderMapper.deleteTWorkOrderById(orderId);
    }
}
