package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TOrderFeedbackMapper;
import com.zehong.system.domain.TOrderFeedback;
import com.zehong.system.service.ITOrderFeedbackService;

/**
 * 工单反馈信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-19
 */
@Service
public class TOrderFeedbackServiceImpl implements ITOrderFeedbackService 
{
    @Autowired
    private TOrderFeedbackMapper tOrderFeedbackMapper;

    /**
     * 查询工单反馈信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 工单反馈信息
     */
    @Override
    public TOrderFeedback selectTOrderFeedbackById(Long feedbackId)
    {
        return tOrderFeedbackMapper.selectTOrderFeedbackById(feedbackId);
    }

    /**
     * 查询工单反馈信息列表
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 工单反馈信息
     */
    @Override
    public List<TOrderFeedback> selectTOrderFeedbackList(TOrderFeedback tOrderFeedback)
    {
        return tOrderFeedbackMapper.selectTOrderFeedbackList(tOrderFeedback);
    }

    /**
     * 新增工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    @Override
    public int insertTOrderFeedback(TOrderFeedback tOrderFeedback)
    {
        return tOrderFeedbackMapper.insertTOrderFeedback(tOrderFeedback);
    }

    /**
     * 修改工单反馈信息
     * 
     * @param tOrderFeedback 工单反馈信息
     * @return 结果
     */
    @Override
    public int updateTOrderFeedback(TOrderFeedback tOrderFeedback)
    {
        return tOrderFeedbackMapper.updateTOrderFeedback(tOrderFeedback);
    }

    /**
     * 批量删除工单反馈信息
     * 
     * @param feedbackIds 需要删除的工单反馈信息ID
     * @return 结果
     */
    @Override
    public int deleteTOrderFeedbackByIds(Long[] feedbackIds)
    {
        return tOrderFeedbackMapper.deleteTOrderFeedbackByIds(feedbackIds);
    }

    /**
     * 删除工单反馈信息信息
     * 
     * @param feedbackId 工单反馈信息ID
     * @return 结果
     */
    @Override
    public int deleteTOrderFeedbackById(Long feedbackId)
    {
        return tOrderFeedbackMapper.deleteTOrderFeedbackById(feedbackId);
    }
}
