package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectorMapper;
import com.zehong.system.domain.TInspector;
import com.zehong.system.service.ITInspectorService;

/**
 * 巡检员Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-08
 */
@Service
public class TInspectorServiceImpl implements ITInspectorService 
{
    @Autowired
    private TInspectorMapper tInspectorMapper;

    /**
     * 查询巡检员
     * 
     * @param inspectorId 巡检员ID
     * @return 巡检员
     */
    @Override
    public TInspector selectTInspectorById(Long inspectorId)
    {
        return tInspectorMapper.selectTInspectorById(inspectorId);
    }

    /**
     * 查询巡检员列表
     * 
     * @param tInspector 巡检员
     * @return 巡检员
     */
    @Override
    public List<TInspector> selectTInspectorList(TInspector tInspector)
    {
        return tInspectorMapper.selectTInspectorList(tInspector);
    }

    /**
     * 新增巡检员
     * 
     * @param tInspector 巡检员
     * @return 结果
     */
    @Override
    public int insertTInspector(TInspector tInspector)
    {
        return tInspectorMapper.insertTInspector(tInspector);
    }

    /**
     * 修改巡检员
     * 
     * @param tInspector 巡检员
     * @return 结果
     */
    @Override
    public int updateTInspector(TInspector tInspector)
    {
        return tInspectorMapper.updateTInspector(tInspector);
    }

    /**
     * 批量删除巡检员
     * 
     * @param inspectorIds 需要删除的巡检员ID
     * @return 结果
     */
    @Override
    public int deleteTInspectorByIds(Long[] inspectorIds)
    {
        return tInspectorMapper.deleteTInspectorByIds(inspectorIds);
    }

    /**
     * 删除巡检员信息
     * 
     * @param inspectorId 巡检员ID
     * @return 结果
     */
    @Override
    public int deleteTInspectorById(Long inspectorId)
    {
        return tInspectorMapper.deleteTInspectorById(inspectorId);
    }
}
