package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检员对象 t_inspector
 * 
 * @author zehong
 * @date 2021-07-08
 */
public class TInspector extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检员id */
    private Long inspectorId;

    /** 企业id */
    @Excel(name = "企业id")
    private Long enterpriseId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setInspectorId(Long inspectorId) 
    {
        this.inspectorId = inspectorId;
    }

    public Long getInspectorId() 
    {
        return inspectorId;
    }
    public void setEnterpriseId(Long enterpriseId) 
    {
        this.enterpriseId = enterpriseId;
    }

    public Long getEnterpriseId() 
    {
        return enterpriseId;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("inspectorId", getInspectorId())
            .append("enterpriseId", getEnterpriseId())
            .append("name", getName())
            .append("phone", getPhone())
            .append("remarks", getRemarks())
            .toString();
    }
}
