import request from '@/utils/request'

// 查询巡检员列表
export function listInspector(query) {
  return request({
    url: '/deviceInspection/inspector/list',
    method: 'get',
    params: query
  })
}

// 查询巡检员详细
export function getInspector(inspectorId) {
  return request({
    url: '/deviceInspection/inspector/' + inspectorId,
    method: 'get'
  })
}

// 新增巡检员
export function addInspector(data) {
  return request({
    url: '/deviceInspection/inspector',
    method: 'post',
    data: data
  })
}

// 修改巡检员
export function updateInspector(data) {
  return request({
    url: '/deviceInspection/inspector',
    method: 'put',
    data: data
  })
}

// 删除巡检员
export function delInspector(inspectorId) {
  return request({
    url: '/deviceInspection/inspector/' + inspectorId,
    method: 'delete'
  })
}

// 导出巡检员
export function exportInspector(query) {
  return request({
    url: '/deviceInspection/inspector/export',
    method: 'get',
    params: query
  })
}
