import request from '@/utils/request'

// 查询管道信息列表
export function listPipe(query) {
  return request({
    url: '/device/pipe/list',
    method: 'get',
    params: query
  })
}

// 查询管道信息详细
export function getPipe(pipeId) {
  return request({
    url: '/device/pipe/' + pipeId,
    method: 'get'
  })
}

// 新增管道信息
export function addPipe(data) {
  return request({
    url: '/device/pipe',
    method: 'post',
    data: data
  })
}

// 修改管道信息
export function updatePipe(data) {
  return request({
    url: '/device/pipe',
    method: 'put',
    data: data
  })
}

// 删除管道信息
export function delPipe(pipeId) {
  return request({
    url: '/device/pipe/' + pipeId,
    method: 'delete'
  })
}

// 导出管道信息
export function exportPipe(query) {
  return request({
    url: '/device/pipe/export',
    method: 'get',
    params: query
  })
}

// 统计各设备类型的设备总数
export function countPipeLength(){
  return request({
    url: '/device/pipe/countPipeLength',
    method: 'get'
  })
}
