package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEnterpriseInfo;

/**
 * 企业基本信息Mapper接口
 * 
 * @author zehong
 * @date 2021-06-30
 */
public interface TEnterpriseInfoMapper 
{
    /**
     * 查询企业基本信息
     * 
     * @param infoId 企业基本信息ID
     * @return 企业基本信息
     */
    public TEnterpriseInfo selectTEnterpriseInfoById(Long infoId);

    /**
     * 查询企业基本信息列表
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 企业基本信息集合
     */
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 新增企业基本信息
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 结果
     */
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 修改企业基本信息
     * 
     * @param tEnterpriseInfo 企业基本信息
     * @return 结果
     */
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo);

    /**
     * 删除企业基本信息
     * 
     * @param infoId 企业基本信息ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoById(Long infoId);

    /**
     * 批量删除企业基本信息
     * 
     * @param infoIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEnterpriseInfoByIds(Long[] infoIds);
}
