package com.zehong.web.controller.deviceInspection;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TInspector;
import com.zehong.system.service.ITInspectorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 巡检员Controller
 * 
 * @author zehong
 * @date 2021-07-08
 */
@RestController
@RequestMapping("/deviceInspection/inspector")
public class TInspectorController extends BaseController
{
    @Autowired
    private ITInspectorService tInspectorService;

    /**
     * 查询巡检员列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:list')")
    @GetMapping("/list")
    public TableDataInfo list(TInspector tInspector)
    {
        startPage();
        List<TInspector> list = tInspectorService.selectTInspectorList(tInspector);
        return getDataTable(list);
    }

    /**
     * 导出巡检员列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:export')")
    @Log(title = "巡检员", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspector tInspector)
    {
        List<TInspector> list = tInspectorService.selectTInspectorList(tInspector);
        ExcelUtil<TInspector> util = new ExcelUtil<TInspector>(TInspector.class);
        return util.exportExcel(list, "巡检员数据");
    }

    /**
     * 获取巡检员详细信息
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:query')")
    @GetMapping(value = "/{inspectorId}")
    public AjaxResult getInfo(@PathVariable("inspectorId") Long inspectorId)
    {
        return AjaxResult.success(tInspectorService.selectTInspectorById(inspectorId));
    }

    /**
     * 新增巡检员
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:add')")
    @Log(title = "巡检员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspector tInspector)
    {
        return toAjax(tInspectorService.insertTInspector(tInspector));
    }

    /**
     * 修改巡检员
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:edit')")
    @Log(title = "巡检员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspector tInspector)
    {
        return toAjax(tInspectorService.updateTInspector(tInspector));
    }

    /**
     * 删除巡检员
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspector:remove')")
    @Log(title = "巡检员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{inspectorIds}")
    public AjaxResult remove(@PathVariable Long[] inspectorIds)
    {
        return toAjax(tInspectorService.deleteTInspectorByIds(inspectorIds));
    }
}
