import request from '@/utils/request'

// 查询事故台账列表
export function listTrouble(query) {
  return request({
    url: '/standingBook/trouble/list',
    method: 'get',
    params: query
  })
}

// 查询事故台账详细
export function getTrouble(troubleId) {
  return request({
    url: '/standingBook/trouble/' + troubleId,
    method: 'get'
  })
}

// 新增事故台账
export function addTrouble(data) {
  return request({
    url: '/standingBook/trouble',
    method: 'post',
    data: data
  })
}

// 修改事故台账
export function updateTrouble(data) {
  return request({
    url: '/standingBook/trouble',
    method: 'put',
    data: data
  })
}

// 删除事故台账
export function delTrouble(troubleId) {
  return request({
    url: '/standingBook/trouble/' + troubleId,
    method: 'delete'
  })
}

// 导出事故台账
export function exportTrouble(query) {
  return request({
    url: '/standingBook/trouble/export',
    method: 'get',
    params: query
  })
}