import request from '@/utils/request'

// 查询设备监控列表
export function listData(query) {
  return request({
    url: '/system/data/list',
    method: 'get',
    params: query
  })
}

// 查询设备监控详细
export function getData(deviceReportDataId) {
  return request({
    url: '/system/data/' + deviceReportDataId,
    method: 'get'
  })
}

// 新增设备监控
export function addData(data) {
  return request({
    url: '/system/data',
    method: 'post',
    data: data
  })
}

// 修改设备监控
export function updateData(data) {
  return request({
    url: '/system/data',
    method: 'put',
    data: data
  })
}

// 删除设备监控
export function delData(deviceReportDataId) {
  return request({
    url: '/system/data/' + deviceReportDataId,
    method: 'delete'
  })
}

// 导出设备监控
export function exportData(query) {
  return request({
    url: '/system/data/export',
    method: 'get',
    params: query
  })
}