import request from '@/utils/request'

// 查询投诉处置列表
export function listComplainDeal(query) {
  return request({
    url: '/complainDeal/list',
    method: 'get',
    params: query
  })
}

// 查询投诉处置详细
export function getComplainDeal(complainDealId) {
  return request({
    url: '/complainDeal/' + complainDealId,
    method: 'get'
  })
}

// 新增投诉处置
export function addComplainDeal(data) {
  return request({
    url: '/complainDeal',
    method: 'post',
    data: data
  })
}

// 修改投诉处置
export function updateComplainDeal(data) {
  return request({
    url: '/complainDeal',
    method: 'put',
    data: data
  })
}

// 删除投诉处置
export function delComplainDeal(complainDealId) {
  return request({
    url: '/complainDeal/' + complainDealId,
    method: 'delete'
  })
}

// 导出投诉处置
export function exportComplainDeal(query) {
  return request({
    url: '/complainDeal/complainDeal/export',
    method: 'get',
    params: query
  })
}
