package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.form.TTroubleStandingBookForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTroubleStandingBookMapper;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.service.ITTroubleStandingBookService;

/**
 * 事故台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-09
 */
@Service
public class TTroubleStandingBookServiceImpl implements ITTroubleStandingBookService 
{
    @Autowired
    private TTroubleStandingBookMapper tTroubleStandingBookMapper;

    /**
     * 查询事故台账
     * 
     * @param troubleId 事故台账ID
     * @return 事故台账
     */
    @Override
    public TTroubleStandingBook selectTTroubleStandingBookById(Long troubleId)
    {
        return tTroubleStandingBookMapper.selectTTroubleStandingBookById(troubleId);
    }

    /**
     * 查询事故台账列表
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 事故台账
     */
    @Override
    public List<TTroubleStandingBook> selectTTroubleStandingBookList(TTroubleStandingBookForm tTroubleStandingBook)
    {
        return tTroubleStandingBookMapper.selectTTroubleStandingBookList(tTroubleStandingBook);
    }

    /**
     * 新增事故台账
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    @Override
    public int insertTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook)
    {
        tTroubleStandingBook.setCreateTime(DateUtils.getNowDate());
        return tTroubleStandingBookMapper.insertTTroubleStandingBook(tTroubleStandingBook);
    }

    /**
     * 修改事故台账
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    @Override
    public int updateTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook)
    {
        // 是否人员伤亡：2否，受伤人数和死亡人数改为0
        if(tTroubleStandingBook.getIsCasualties().equals("2")){
            tTroubleStandingBook.setInjuryNum(0);
            tTroubleStandingBook.setDeathNum(0);
        }
        tTroubleStandingBook.setUpdateTime(DateUtils.getNowDate());
        return tTroubleStandingBookMapper.updateTTroubleStandingBook(tTroubleStandingBook);
    }

    /**
     * 批量删除事故台账
     * 
     * @param troubleIds 需要删除的事故台账ID
     * @return 结果
     */
    @Override
    public int deleteTTroubleStandingBookByIds(Long[] troubleIds)
    {
        return tTroubleStandingBookMapper.deleteTTroubleStandingBookByIds(troubleIds);
    }

    /**
     * 删除事故台账信息
     * 
     * @param troubleId 事故台账ID
     * @return 结果
     */
    @Override
    public int deleteTTroubleStandingBookById(Long troubleId)
    {
        return tTroubleStandingBookMapper.deleteTTroubleStandingBookById(troubleId);
    }
}
