package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TPlanInfo;

/**
 * 应急预案Service接口
 * 
 * @author zehong
 * @date 2022-02-11
 */
public interface ITPlanInfoService 
{
    /**
     * 查询应急预案
     * 
     * @param planId 应急预案ID
     * @return 应急预案
     */
    public TPlanInfo selectTPlanInfoById(Long planId);

    /**
     * 查询应急预案列表
     * 
     * @param tPlanInfo 应急预案
     * @return 应急预案集合
     */
    public List<TPlanInfo> selectTPlanInfoList(TPlanInfo tPlanInfo);

    /**
     * 新增应急预案
     * 
     * @param tPlanInfo 应急预案
     * @return 结果
     */
    public int insertTPlanInfo(TPlanInfo tPlanInfo);

    /**
     * 修改应急预案
     * 
     * @param tPlanInfo 应急预案
     * @return 结果
     */
    public int updateTPlanInfo(TPlanInfo tPlanInfo);

    /**
     * 批量删除应急预案
     * 
     * @param planIds 需要删除的应急预案ID
     * @return 结果
     */
    public int deleteTPlanInfoByIds(Long[] planIds);

    /**
     * 删除应急预案信息
     * 
     * @param planId 应急预案ID
     * @return 结果
     */
    public int deleteTPlanInfoById(Long planId);

    public List<Map<String,Object>> selectEnterprise();
}
