package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.domain.form.THiddenDangerStandingBookForm;

/**
 * 隐患整治台账Service接口
 * 
 * @author zehong
 * @date 2022-02-09
 */
public interface ITHiddenDangerStandingBookService 
{
    /**
     * 查询隐患整治台账
     * 
     * @param hiddenId 隐患整治台账ID
     * @return 隐患整治台账
     */
    public THiddenDangerStandingBook selectTHiddenDangerStandingBookById(Long hiddenId);

    /**
     * 查询隐患整治台账列表
     * 
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 隐患整治台账集合
     */
    public List<THiddenDangerStandingBook> selectTHiddenDangerStandingBookList(THiddenDangerStandingBookForm tHiddenDangerStandingBook);

    /**
     * 新增隐患整治台账
     * 
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 结果
     */
    public int insertTHiddenDangerStandingBook(THiddenDangerStandingBook tHiddenDangerStandingBook);

    /**
     * 修改隐患整治台账
     * 
     * @param tHiddenDangerStandingBook 隐患整治台账
     * @return 结果
     */
    public int updateTHiddenDangerStandingBook(THiddenDangerStandingBook tHiddenDangerStandingBook);

    /**
     * 批量删除隐患整治台账
     * 
     * @param hiddenIds 需要删除的隐患整治台账ID
     * @return 结果
     */
    public int deleteTHiddenDangerStandingBookByIds(Long[] hiddenIds);

    /**
     * 删除隐患整治台账信息
     * 
     * @param hiddenId 隐患整治台账ID
     * @return 结果
     */
    public int deleteTHiddenDangerStandingBookById(Long hiddenId);
}
