package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TComplainDeal;

/**
 * 投诉处置Service接口
 * 
 * @author zehong
 * @date 2022-02-15
 */
public interface ITComplainDealService 
{
    /**
     * 查询投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 投诉处置
     */
    public TComplainDeal selectTComplainDealById(Long complainDealId);

    /**
     * 查询投诉处置列表
     * 
     * @param tComplainDeal 投诉处置
     * @return 投诉处置集合
     */
    public List<TComplainDeal> selectTComplainDealList(TComplainDeal tComplainDeal);

    /**
     * 新增投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int insertTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 修改投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    public int updateTComplainDeal(TComplainDeal tComplainDeal);

    /**
     * 批量删除投诉处置
     * 
     * @param complainDealIds 需要删除的投诉处置ID
     * @return 结果
     */
    public int deleteTComplainDealByIds(Long[] complainDealIds);

    /**
     * 删除投诉处置信息
     * 
     * @param complainDealId 投诉处置ID
     * @return 结果
     */
    public int deleteTComplainDealById(Long complainDealId);
}
