package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.domain.form.TTroubleStandingBookForm;

/**
 * 事故台账Mapper接口
 * 
 * @author zehong
 * @date 2022-02-09
 */
public interface TTroubleStandingBookMapper 
{
    /**
     * 查询事故台账
     * 
     * @param troubleId 事故台账ID
     * @return 事故台账
     */
    public TTroubleStandingBook selectTTroubleStandingBookById(Long troubleId);

    /**
     * 查询事故台账列表
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 事故台账集合
     */
    public List<TTroubleStandingBook> selectTTroubleStandingBookList(TTroubleStandingBookForm tTroubleStandingBook);

    /**
     * 新增事故台账
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    public int insertTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook);

    /**
     * 修改事故台账
     * 
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    public int updateTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook);

    /**
     * 删除事故台账
     * 
     * @param troubleId 事故台账ID
     * @return 结果
     */
    public int deleteTTroubleStandingBookById(Long troubleId);

    /**
     * 批量删除事故台账
     * 
     * @param troubleIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTroubleStandingBookByIds(Long[] troubleIds);
}
