package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceInfoS;
import org.apache.ibatis.annotations.Param;

/**
 * 设备信息Mapper接口
 *
 * @author zehong
 * @date 2022-01-27
 */
public interface TDeviceInfoMapper
{
    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    public TDeviceInfo selectTDeviceInfoById(Long deviceId);

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息集合
     */
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 删除设备信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(Long deviceId);

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(Long[] deviceIds);

    /**
     * 添加关联设备信息表数据
     * @param gettDeviceInfoS
     */
    void insertDeviceDetailInfo(TDeviceInfoS gettDeviceInfoS);

    /**
     * 获取设备详细信息列表
     * @param deviceId
     * @return
     */
    List<TDeviceInfoS> getdeviceDetailInfo(Long deviceId);

    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    List<TDeviceInfoS> selectDetailInfo(TDeviceInfoS tDeviceInfos);

    /**
     * 关联设备数据删除接口
     * @param deviceIds
     */
    void deleteDetailInfo(Long[] deviceIds);

    /**
     * 关联设备数据删除接口 单条删除
     * @param deviceId
     */
    void deleteDetailinfOS(int deviceId);

    /**
     * 将关联设备信息与设备进行绑定
     * @param gettDeviceInfoS
     */
    void updatetRelationDeviceDetailInfo(@Param("gettDeviceInfoS")List<TDeviceInfoS> gettDeviceInfoS,@Param("id") Long id);

    /**
     * 查询设备已经关联的关联设备
     * @param id
     * @return
     */
    List<TDeviceInfoS> selectDetailInfoList(int id);

    /**
     * 解绑 设备与关联设备关系
     * @param deviceId
     */
    void deleteDeviceDetailInfo(int deviceId);
}
