package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 视频管理对象 t_video_manager
 * 
 * @author zehong
 * @date 2022-02-15
 */
public class TVideoManager extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 视频管理id */
    private Long videoManagerId;

    /** 视频名称 */
    @Excel(name = "视频名称")
    private String videoName;

    /** 视频资源id */
    @Excel(name = "视频资源id")
    private String resourceId;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 视频地址 */
    @Excel(name = "视频地址")
    private String videoAddress;

    /** 视频类型 */
    @Excel(name = "视频类型")
    private String type;

    /** 所属企业 */
    @Excel(name = "所属企业")
    private Long beyondEnterpriseId;

    /** 所属企业名称 */
    @Excel(name = "所属企业名称")
    private String beyondEnterpriseName;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setVideoManagerId(Long videoManagerId) 
    {
        this.videoManagerId = videoManagerId;
    }

    public Long getVideoManagerId() 
    {
        return videoManagerId;
    }
    public void setVideoName(String videoName) 
    {
        this.videoName = videoName;
    }

    public String getVideoName() 
    {
        return videoName;
    }
    public void setResourceId(String resourceId) 
    {
        this.resourceId = resourceId;
    }

    public String getResourceId() 
    {
        return resourceId;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setVideoAddress(String videoAddress) 
    {
        this.videoAddress = videoAddress;
    }

    public String getVideoAddress() 
    {
        return videoAddress;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("videoManagerId", getVideoManagerId())
            .append("videoName", getVideoName())
            .append("resourceId", getResourceId())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("videoAddress", getVideoAddress())
            .append("type", getType())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
