package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 事故台账对象 t_trouble_standing_book
 * 
 * @author zehong
 * @date 2022-02-09
 */
public class TTroubleStandingBook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 事故id */
    private Long troubleId;

    /** 事故名称 */
    @Excel(name = "事故名称")
    private String troubleName;

    /** 事故地点 */
    @Excel(name = "事故地点")
    private String troubleLocation;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 事故类型：1.生产安全事故 2.非生产安全事故 */
    @Excel(name = "事故类型：1.生产安全事故 2.非生产安全事故")
    private String troubleType;

    /** 简要经过 */
    @Excel(name = "简要经过")
    private String briefProcess;

    /** 事故原因 */
    @Excel(name = "事故原因")
    private String troubleReason;

    /** 是否人员伤亡 */
    @Excel(name = "是否人员伤亡")
    private String isCasualties;

    /** 受伤人数 */
    @Excel(name = "受伤人数")
    private int injuryNum;

    /** 死亡人数 */
    @Excel(name = "死亡人数")
    private int deathNum;

    /** 责任单位 */
    @Excel(name = "责任单位")
    private String responsibleUnit;

    /** 责任人员 */
    @Excel(name = "责任人员")
    private String responsiblePeople;

    /** 是否处理：1.已处理 2.未处理 */
    @Excel(name = "是否处理：1.已处理 2.未处理")
    private String isDeal;

    /** 事故发生时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "事故发生时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date happenDate;

    /** 处理完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "处理完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date dealDate;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setTroubleId(Long troubleId) 
    {
        this.troubleId = troubleId;
    }

    public Long getTroubleId() 
    {
        return troubleId;
    }
    public void setTroubleName(String troubleName) 
    {
        this.troubleName = troubleName;
    }

    public String getTroubleName() 
    {
        return troubleName;
    }
    public void setTroubleLocation(String troubleLocation) 
    {
        this.troubleLocation = troubleLocation;
    }

    public String getTroubleLocation() 
    {
        return troubleLocation;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setTroubleType(String troubleType)
    {
        this.troubleType = troubleType;
    }

    public String getTroubleType() 
    {
        return troubleType;
    }
    public void setBriefProcess(String briefProcess) 
    {
        this.briefProcess = briefProcess;
    }

    public String getBriefProcess() 
    {
        return briefProcess;
    }
    public void setTroubleReason(String troubleReason) 
    {
        this.troubleReason = troubleReason;
    }

    public String getTroubleReason() 
    {
        return troubleReason;
    }

    public String getIsCasualties() {
        return isCasualties;
    }

    public void setIsCasualties(String isCasualties) {
        this.isCasualties = isCasualties;
    }

    public int getInjuryNum() {
        return injuryNum;
    }

    public void setInjuryNum(int injuryNum) {
        this.injuryNum = injuryNum;
    }

    public int getDeathNum() {
        return deathNum;
    }

    public void setDeathNum(int deathNum) {
        this.deathNum = deathNum;
    }

    public void setResponsibleUnit(String responsibleUnit)
    {
        this.responsibleUnit = responsibleUnit;
    }

    public String getResponsibleUnit() 
    {
        return responsibleUnit;
    }
    public void setResponsiblePeople(String responsiblePeople) 
    {
        this.responsiblePeople = responsiblePeople;
    }

    public String getResponsiblePeople() 
    {
        return responsiblePeople;
    }
    public void setIsDeal(String isDeal) 
    {
        this.isDeal = isDeal;
    }

    public String getIsDeal() 
    {
        return isDeal;
    }

    public Date getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }

    public void setDealDate(Date dealDate)
    {
        this.dealDate = dealDate;
    }

    public Date getDealDate() 
    {
        return dealDate;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("troubleId", getTroubleId())
            .append("troubleName", getTroubleName())
            .append("troubleLocation", getTroubleLocation())
            .append("troubleType", getTroubleType())
            .append("briefProcess", getBriefProcess())
            .append("troubleReason", getTroubleReason())
            .append("responsibleUnit", getResponsibleUnit())
            .append("responsiblePeople", getResponsiblePeople())
            .append("isDeal", getIsDeal())
            .append("dealDate", getDealDate())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
