package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 投诉处置对象 t_complain_deal
 * 
 * @author zehong
 * @date 2022-02-15
 */
public class TComplainDeal extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 投诉处置id */
    private Long complainDealId;

    /** 投诉人姓名 */
    @Excel(name = "投诉人姓名")
    private String complainName;

    /** 投诉人电话 */
    @Excel(name = "投诉人电话")
    private String complainPhone;

    /** 投诉事项 */
    @Excel(name = "投诉事项")
    private String complainMatter;

    /** 转办记录 */
    @Excel(name = "转办记录")
    private String transferRecord;

    /** 办理情况 */
    @Excel(name = "办理情况")
    private String dealCondition;

    /** 指派单位名称 */
    @Excel(name = "指派单位名称")
    private String complainAssignEnterproseName;

    /** 指派单位id */
    @Excel(name = "指派单位id")
    private Long complainAssignEnterproseId;

    /** 指派人 */
    @Excel(name = "指派人")
    private String complainAssignManId;

    /** 指派人id */
    @Excel(name = "指派人id")
    private Long complainAssignMan;

    /** 任务状态：1.派发中 2.反馈 3.归档 */
    @Excel(name = "任务状态：1.派发中 2.反馈 3.归档")
    private String complainStatus;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setComplainDealId(Long complainDealId) 
    {
        this.complainDealId = complainDealId;
    }

    public Long getComplainDealId() 
    {
        return complainDealId;
    }
    public void setComplainName(String complainName) 
    {
        this.complainName = complainName;
    }

    public String getComplainName() 
    {
        return complainName;
    }
    public void setComplainPhone(String complainPhone) 
    {
        this.complainPhone = complainPhone;
    }

    public String getComplainPhone() 
    {
        return complainPhone;
    }
    public void setComplainMatter(String complainMatter) 
    {
        this.complainMatter = complainMatter;
    }

    public String getComplainMatter() 
    {
        return complainMatter;
    }
    public void setTransferRecord(String transferRecord) 
    {
        this.transferRecord = transferRecord;
    }

    public String getTransferRecord() 
    {
        return transferRecord;
    }
    public void setDealCondition(String dealCondition) 
    {
        this.dealCondition = dealCondition;
    }

    public String getDealCondition() 
    {
        return dealCondition;
    }
    public void setComplainAssignEnterproseName(String complainAssignEnterproseName) 
    {
        this.complainAssignEnterproseName = complainAssignEnterproseName;
    }

    public String getComplainAssignEnterproseName() 
    {
        return complainAssignEnterproseName;
    }
    public void setComplainAssignEnterproseId(Long complainAssignEnterproseId) 
    {
        this.complainAssignEnterproseId = complainAssignEnterproseId;
    }

    public Long getComplainAssignEnterproseId() 
    {
        return complainAssignEnterproseId;
    }
    public void setComplainAssignManId(String complainAssignManId) 
    {
        this.complainAssignManId = complainAssignManId;
    }

    public String getComplainAssignManId() 
    {
        return complainAssignManId;
    }
    public void setComplainAssignMan(Long complainAssignMan) 
    {
        this.complainAssignMan = complainAssignMan;
    }

    public Long getComplainAssignMan() 
    {
        return complainAssignMan;
    }
    public void setComplainStatus(String complainStatus) 
    {
        this.complainStatus = complainStatus;
    }

    public String getComplainStatus() 
    {
        return complainStatus;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("complainDealId", getComplainDealId())
            .append("complainName", getComplainName())
            .append("complainPhone", getComplainPhone())
            .append("complainMatter", getComplainMatter())
            .append("transferRecord", getTransferRecord())
            .append("dealCondition", getDealCondition())
            .append("complainAssignEnterproseName", getComplainAssignEnterproseName())
            .append("complainAssignEnterproseId", getComplainAssignEnterproseId())
            .append("complainAssignManId", getComplainAssignManId())
            .append("complainAssignMan", getComplainAssignMan())
            .append("complainStatus", getComplainStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
