package com.zehong.web.controller.video;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.TVideoManager;
import com.zehong.system.domain.vo.EnterpriseVideoTreeNode;
import com.zehong.system.service.ITEnterpriseInfoService;
import com.zehong.system.service.ITVideoManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 视频管理Controller
 * 
 * @author zehong
 * @date 2022-02-15
 */
@RestController
@RequestMapping("/system/manager")
public class TVideoManagerController extends BaseController
{
    @Autowired
    private ITVideoManagerService tVideoManagerService;

    @Autowired
    private ITEnterpriseInfoService itEmployedPeopleInfoService;

    /**
     * 查询视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:manager:list')")
    @GetMapping("/list")
    public TableDataInfo list(TVideoManager tVideoManager)
    {
        startPage();
        List<TVideoManager> list = tVideoManagerService.selectTVideoManagerList(tVideoManager);
        return getDataTable(list);
    }

    /**
     * 导出视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:manager:export')")
    @Log(title = "视频管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVideoManager tVideoManager)
    {
        List<TVideoManager> list = tVideoManagerService.selectTVideoManagerList(tVideoManager);
        ExcelUtil<TVideoManager> util = new ExcelUtil<TVideoManager>(TVideoManager.class);
        return util.exportExcel(list, "视频管理数据");
    }

    /**
     * 获取视频tree
     * @param tVideoManager
     * @return
     */
    @GetMapping("/getVideoTree")
    public AjaxResult getVideoTree(TVideoManager tVideoManager){

        List<EnterpriseVideoTreeNode> enterpriseVideoList = new ArrayList<>();


        //I级树
        EnterpriseVideoTreeNode enterpriseVideoFirst = new EnterpriseVideoTreeNode();
        List<EnterpriseVideoTreeNode> enterpriseVideoFirstChildrnList = new ArrayList<>();
        enterpriseVideoFirst.setVideoName("企业监控");
        enterpriseVideoFirst.setLevel("1");


        List<TEnterpriseInfo> tEnterpriseInfos = itEmployedPeopleInfoService.selectTEnterpriseInfoList(new TEnterpriseInfo());
        for(TEnterpriseInfo tEnterpriseInfo : tEnterpriseInfos){


            //II级树
            EnterpriseVideoTreeNode enterpriseVideoSecond= new EnterpriseVideoTreeNode();
            List<EnterpriseVideoTreeNode> enterpriseVideoSecondChildrenList = new ArrayList<>();
            enterpriseVideoSecond.setVideoName(tEnterpriseInfo.getEnterpriseName());
            enterpriseVideoSecond.setLevel("2");


            tVideoManager.setBeyondEnterpriseId(tEnterpriseInfo.getEnterpriseId());
            List<TVideoManager> tVideoManagers = tVideoManagerService.selectTVideoManagerList(tVideoManager);
            for(TVideoManager manager : tVideoManagers){
                //III级树
                EnterpriseVideoTreeNode enterpriseVideoThird= new EnterpriseVideoTreeNode();
                enterpriseVideoThird.setVideoName(manager.getVideoName());
                enterpriseVideoThird.setResourceId(manager.getResourceId());
                enterpriseVideoThird.setLevel("3");
                enterpriseVideoSecondChildrenList.add(enterpriseVideoThird);
            }
            enterpriseVideoSecond.setChildrenVideo(enterpriseVideoSecondChildrenList);
            enterpriseVideoFirstChildrnList.add(enterpriseVideoSecond);
        }
        enterpriseVideoFirst.setChildrenVideo(enterpriseVideoFirstChildrnList);
        enterpriseVideoList.add(enterpriseVideoFirst);
        return AjaxResult.success(enterpriseVideoList);
    }

    /**
     * 获取视频管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:manager:query')")
    @GetMapping(value = "/{videoManagerId}")
    public AjaxResult getInfo(@PathVariable("videoManagerId") Long videoManagerId)
    {
        return AjaxResult.success(tVideoManagerService.selectTVideoManagerById(videoManagerId));
    }

    /**
     * 新增视频管理
     */
    @PreAuthorize("@ss.hasPermi('system:manager:add')")
    @Log(title = "视频管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVideoManager tVideoManager)
    {
        return toAjax(tVideoManagerService.insertTVideoManager(tVideoManager));
    }

    /**
     * 修改视频管理
     */
    @PreAuthorize("@ss.hasPermi('system:manager:edit')")
    @Log(title = "视频管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVideoManager tVideoManager)
    {
        return toAjax(tVideoManagerService.updateTVideoManager(tVideoManager));
    }

    /**
     * 删除视频管理
     */
    @PreAuthorize("@ss.hasPermi('system:manager:remove')")
    @Log(title = "视频管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{videoManagerIds}")
    public AjaxResult remove(@PathVariable Long[] videoManagerIds)
    {
        return toAjax(tVideoManagerService.deleteTVideoManagerByIds(videoManagerIds));
    }
}
