package com.zehong.web.controller.system;

import java.util.List;
import java.util.Set;

import com.zehong.framework.systemsetting.SystemSetting;
import com.zehong.system.service.ISysPostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.constant.Constants;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysMenu;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginBody;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.SysLoginService;
import com.zehong.framework.web.service.SysPermissionService;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.service.ISysMenuService;

/**
 * 登录验证
 * 
 * @author zehong
 */
@RestController
public class SysLoginController
{
    @Autowired
    private SysLoginService loginService;

    @Autowired
    private ISysMenuService menuService;

    @Autowired
    private SysPermissionService permissionService;

    @Autowired
    private TokenService tokenService;

    @Autowired
    private SystemSetting systemSetting;

    @Autowired
    private ISysPostService iSysPostService;

    /**
     * 登录方法
     * 
     * @param loginBody 登录信息
     * @return 结果
     */
    @PostMapping("/login")
    public AjaxResult login(@RequestBody LoginBody loginBody)
    {
        AjaxResult ajax = AjaxResult.success();
        // 生成令牌
        String token = loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(),
                loginBody.getUuid());
        ajax.put(Constants.TOKEN, token);
        return ajax;
    }

    /**
     * 获取用户信息
     * 
     * @return 用户信息
     */
    @GetMapping("getInfo")
    public AjaxResult getInfo()
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        // 角色集合
        Set<String> roles = permissionService.getRolePermission(user);
        // 权限集合
        Set<String> permissions = permissionService.getMenuPermission(user);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", user);
        ajax.put("roles", roles);
        ajax.put("permissions", permissions);
        ajax.put("systemSetting",systemSetting.getSystemWebSetting());
        ajax.put("posts",iSysPostService.getPostListByUserId(user.getUserId()));
        return ajax;
    }

    /**
     * 获取路由信息
     * 
     * @return 路由信息
     */
    @GetMapping("getRouters")
    public AjaxResult getRouters()
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        // 用户信息
        SysUser user = loginUser.getUser();
        List<SysMenu> menus = menuService.selectMenuTreeByUserId(user.getUserId());
        return AjaxResult.success(menuService.buildMenus(menus));
    }
}
