package com.zehong.web.controller.supervise;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.service.ITDetectorUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气用户Controller
 *
 * @author zehong
 * @date 2022-02-07
 */
@RestController
@RequestMapping("/supervise/user")
public class TDetectorUserController extends BaseController
{
    @Autowired
    private ITDetectorUserService tDetectorUserService;

    /**
     * 查询燃气用户列表
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDetectorUser tDetectorUser)
    {
        startPage();
        List<TDetectorUser> list = tDetectorUserService.selectTDetectorUserList(tDetectorUser);
        return getDataTable(list);
    }

    /**
     * 导出燃气用户列表
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:export')")
    @Log(title = "燃气用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDetectorUser tDetectorUser)
    {
        List<TDetectorUser> list = tDetectorUserService.selectTDetectorUserList(tDetectorUser);
        ExcelUtil<TDetectorUser> util = new ExcelUtil<TDetectorUser>(TDetectorUser.class);
        return util.exportExcel(list, "燃气用户数据");
    }

    /**
     * 获取燃气用户详细信息
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:query')")
    @GetMapping(value = "/{userId}")
    public AjaxResult getInfo(@PathVariable("userId") Long userId)
    {
        return AjaxResult.success(tDetectorUserService.selectTDetectorUserById(userId));
    }

    /**
     * 新增燃气用户
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:add')")
    @Log(title = "燃气用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDetectorUser tDetectorUser)
    {
        return toAjax(tDetectorUserService.insertTDetectorUser(tDetectorUser));
    }

    /**
     * 修改燃气用户
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:edit')")
    @Log(title = "燃气用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDetectorUser tDetectorUser)
    {
        return toAjax(tDetectorUserService.updateTDetectorUser(tDetectorUser));
    }

    /**
     * 删除燃气用户
     */
    @PreAuthorize("@ss.hasPermi('supervise:user:remove')")
    @Log(title = "燃气用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{userIds}")
    public AjaxResult remove(@PathVariable Long[] userIds)
    {
        return toAjax(tDetectorUserService.deleteTDetectorUserByIds(userIds));
    }
}
