package com.zehong.web.controller.standingBook;

import java.util.List;

import com.zehong.system.domain.form.TSafeEquipmentStandingBookForm;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.service.ITSafeEquipmentStandingBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 用户加装安全装置台账Controller
 * 
 * @author zehong
 * @date 2022-02-09
 */
@RestController
@RequestMapping("/standingBook/equipment")
public class TSafeEquipmentStandingBookController extends BaseController
{
    @Autowired
    private ITSafeEquipmentStandingBookService tSafeEquipmentStandingBookService;

    /**
     * 查询用户加装安全装置台账列表
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSafeEquipmentStandingBookForm tSafeEquipmentStandingBook)
    {
        startPage();
        List<TSafeEquipmentStandingBook> list = tSafeEquipmentStandingBookService.selectTSafeEquipmentStandingBookList(tSafeEquipmentStandingBook);
        return getDataTable(list);
    }

    /**
     * 导出用户加装安全装置台账列表
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:export')")
    @Log(title = "用户加装安全装置台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSafeEquipmentStandingBookForm tSafeEquipmentStandingBook)
    {
        List<TSafeEquipmentStandingBook> list = tSafeEquipmentStandingBookService.selectTSafeEquipmentStandingBookList(tSafeEquipmentStandingBook);
        ExcelUtil<TSafeEquipmentStandingBook> util = new ExcelUtil<TSafeEquipmentStandingBook>(TSafeEquipmentStandingBook.class);
        return util.exportExcel(list, "用户加装安全装置台账数据");
    }

    /**
     * 获取用户加装安全装置台账详细信息
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:query')")
    @GetMapping(value = "/{safeEquipmentId}")
    public AjaxResult getInfo(@PathVariable("safeEquipmentId") Long safeEquipmentId)
    {
        return AjaxResult.success(tSafeEquipmentStandingBookService.selectTSafeEquipmentStandingBookById(safeEquipmentId));
    }

    /**
     * 新增用户加装安全装置台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:add')")
    @Log(title = "用户加装安全装置台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        return toAjax(tSafeEquipmentStandingBookService.insertTSafeEquipmentStandingBook(tSafeEquipmentStandingBook));
    }

    /**
     * 修改用户加装安全装置台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:edit')")
    @Log(title = "用户加装安全装置台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        return toAjax(tSafeEquipmentStandingBookService.updateTSafeEquipmentStandingBook(tSafeEquipmentStandingBook));
    }

    /**
     * 删除用户加装安全装置台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:equipment:remove')")
    @Log(title = "用户加装安全装置台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{safeEquipmentIds}")
    public AjaxResult remove(@PathVariable Long[] safeEquipmentIds)
    {
        return toAjax(tSafeEquipmentStandingBookService.deleteTSafeEquipmentStandingBookByIds(safeEquipmentIds));
    }
}
