import request from '@/utils/request'

// 查询应急预案列表
export function listPlanInfo(query) {
  return request({
    url: '/system/planInfo/list',
    method: 'get',
    params: query
  })
}

// 查询应急预案详细
export function getPlanInfo(planId) {
  return request({
    url: '/system/planInfo/' + planId,
    method: 'get'
  })
}
// 公司列表
export function enterpriseList() {
  return request({
    url: '/system/planInfo/getEnterpris',
    method: 'get'
  })
}
// 新增应急预案
export function addPlanInfo(data) {
  return request({
    url: '/system/planInfo',
    method: 'post',
    data: data
  })
}

// 修改应急预案
export function updatePlanInfo(data) {
  return request({
    url: '/system/planInfo',
    method: 'put',
    data: data
  })
}

// 删除应急预案
export function delPlanInfo(planId) {
  return request({
    url: '/system/planInfo/' + planId,
    method: 'delete'
  })
}

// 导出应急预案
export function exportPlanInfo(query) {
  return request({
    url: '/system/planInfo/export',
    method: 'get',
    params: query
  })
}
