import request from '@/utils/request'

// 查询事件处置列表
export function listEventInfo(query) {
  return request({
    url: '/system/eventInfo/list',
    method: 'get',
    params: query
  })
}
// 公司列表
export function enterpriseList() {
  return request({
    url: '/system/planInfo/getEnterpris',
    method: 'get'
  })
}
// 查询事件处置详细
export function getEventInfo(eventId) {
  return request({
    url: '/system/eventInfo/' + eventId,
    method: 'get'
  })
}

// 新增事件处置
export function addEventInfo(data) {
  return request({
    url: '/system/eventInfo',
    method: 'post',
    data: data
  })
}

// 修改事件处置
export function updateEventInfo(data) {
  return request({
    url: '/system/eventInfo',
    method: 'put',
    data: data
  })
}

// 删除事件处置
export function delEventInfo(eventId) {
  return request({
    url: '/system/eventInfo/' + eventId,
    method: 'delete'
  })
}

// 导出事件处置
export function exportEventInfo(query) {
  return request({
    url: '/system/eventInfo/export',
    method: 'get',
    params: query
  })
}
