import request from '@/utils/request'

// 查询燃气用户列表
export function listUser(query) {
  return request({
    url: '/supervise/user/list',
    method: 'get',
    params: query
  })
}

// 查询燃气用户详细
export function getUser(userId) {
  return request({
    url: '/supervise/user/' + userId,
    method: 'get'
  })
}

// 新增燃气用户
export function addUser(data) {
  return request({
    url: '/supervise/user',
    method: 'post',
    data: data
  })
}

// 修改燃气用户
export function updateUser(data) {
  return request({
    url: '/supervise/user',
    method: 'put',
    data: data
  })
}

// 删除燃气用户
export function delUser(userId) {
  return request({
    url: '/supervise/user/' + userId,
    method: 'delete'
  })
}

// 导出燃气用户
export function exportUser(query) {
  return request({
    url: '/supervise/user/export',
    method: 'get',
    params: query
  })
}