import request from '@/utils/request'

// 查询从业人员信息列表
export function listInfo(query) {
  return request({
    url: '/regulation/supervise/list',
    method: 'get',
    params: query
  })
}

// 查询从业人员信息详细
export function getInfo(employedPeopleId) {
  return request({
    url: '/regulation/supervise/' + employedPeopleId,
    method: 'get'
  })
}

// 新增从业人员信息
export function addInfo(data) {
  return request({
    url: '/regulation/supervise',
    method: 'post',
    data: data
  })
}

// 修改从业人员信息
export function updateInfo(data) {
  return request({
    url: '/regulation/supervise',
    method: 'put',
    data: data
  })
}

// 删除从业人员信息
export function delInfo(employedPeopleId) {
  return request({
    url: '/regulation/supervise/' + employedPeopleId,
    method: 'delete'
  })
}

// 导出从业人员信息
export function exportInfo(query) {
  return request({
    url: '/regulation/supervise/export',
    method: 'get',
    params: query
  })
}

// 企业信息查询(下拉框)
export function selectTEnterprise() {
    return request({
      url: '/regulation/supervise/selectTEnterprise',
      method: 'get'
    })
  }

