package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.domain.vo.HomepageVo;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.mapper.TWorkOrderMapper;
import com.zehong.system.service.ITWorkOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 燃气任务Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-10
 */
@Service
public class TWorkOrderServiceImpl implements ITWorkOrderService 
{
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;

    @Autowired
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询燃气任务
     * 
     * @param workId 燃气任务ID
     * @return 燃气任务
     */
    @Override
    public TWorkOrder selectTWorkOrderById(Long workId)
    {
        return tWorkOrderMapper.selectTWorkOrderById(workId);
    }

    /**
     * 查询燃气任务列表
     * 
     * @param tWorkOrder 燃气任务
     * @return 燃气任务
     */
    @Override
    public List<TWorkOrder> selectTWorkOrderList(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.selectTWorkOrderList(tWorkOrder);
    }

    /**
     * 燃气任务统计
     *
     * @return 燃气任务统计
     */
    public HomepageVo countTWorkOrder()
    {
        return tWorkOrderMapper.countTWorkOrder();
    }

    /**
     * 新增燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    @Override
    public int insertTWorkOrder(TWorkOrder tWorkOrder)
    {
        tWorkOrder.setCreateTime(DateUtils.getNowDate());
        tWorkOrder.setCreateBy(SecurityUtils.getUsername());
        Long enterpriseId = SecurityUtils.getLoginUser().getUser().getDeptId();
        if(null != enterpriseId){
            if("-2".equals(enterpriseId.toString())){
                tWorkOrder.setWorkCreateEnterpriseId("-2");
                tWorkOrder.setWorkCreateEnterpriseName("政府部门");
            }else{

                TEnterpriseInfo enterpriseInfo = tEnterpriseInfoMapper.selectTEnterpriseInfoById(enterpriseId);
                if(null != enterpriseInfo && StringUtils.isNotEmpty(enterpriseInfo.getEnterpriseName())){
                    tWorkOrder.setWorkCreateEnterpriseId(enterpriseId.toString());
                    tWorkOrder.setWorkCreateEnterpriseName(enterpriseInfo.getEnterpriseName());
                }

            }
        }
        return tWorkOrderMapper.insertTWorkOrder(tWorkOrder);
    }

    /**
     * 修改燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    @Override
    public int updateTWorkOrder(TWorkOrder tWorkOrder)
    {
        tWorkOrder.setUpdateTime(DateUtils.getNowDate());
        tWorkOrder.setUpdateBy(SecurityUtils.getUsername());
        /*if(StringUtils.isNotEmpty(tWorkOrder.getIconUrl()) || StringUtils.isNotEmpty(tWorkOrder.getRectificationResult())){
            tWorkOrder.setWorkStatus("2");
        }*/
        return tWorkOrderMapper.updateTWorkOrder(tWorkOrder);
    }

    /**
     * 批量删除燃气任务
     * 
     * @param workIds 需要删除的燃气任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderByIds(Long[] workIds)
    {
        return tWorkOrderMapper.deleteTWorkOrderByIds(workIds);
    }

    /**
     * 删除燃气任务信息
     * 
     * @param workId 燃气任务ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderById(Long workId)
    {
        return tWorkOrderMapper.deleteTWorkOrderById(workId);
    }
}
