package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEnterpriseInfoMapper;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.service.ITEnterpriseInfoService;

/**
 * 企业信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-01-24
 */
@Service
public class TEnterpriseInfoServiceImpl implements ITEnterpriseInfoService 
{
    @Autowired
    private TEnterpriseInfoMapper tEnterpriseInfoMapper;

    /**
     * 查询企业信息
     * 
     * @param enterpriseId 企业信息ID
     * @return 企业信息
     */
    @Override
    public TEnterpriseInfo selectTEnterpriseInfoById(Long enterpriseId)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoById(enterpriseId);
    }

    /**
     * 查询企业信息列表
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 企业信息
     */
    @Override
    public List<TEnterpriseInfo> selectTEnterpriseInfoList(TEnterpriseInfo tEnterpriseInfo)
    {
        return tEnterpriseInfoMapper.selectTEnterpriseInfoList(tEnterpriseInfo);
    }

    /**
     * 新增企业信息
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    @Override
    public int insertTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setCreateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.insertTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 修改企业信息
     * 
     * @param tEnterpriseInfo 企业信息
     * @return 结果
     */
    @Override
    public int updateTEnterpriseInfo(TEnterpriseInfo tEnterpriseInfo)
    {
        tEnterpriseInfo.setUpdateTime(DateUtils.getNowDate());
        return tEnterpriseInfoMapper.updateTEnterpriseInfo(tEnterpriseInfo);
    }

    /**
     * 批量删除企业信息
     * 
     * @param enterpriseIds 需要删除的企业信息ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoByIds(Long[] enterpriseIds)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoByIds(enterpriseIds);
    }

    /**
     * 删除企业信息信息
     * 
     * @param enterpriseId 企业信息ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseInfoById(Long enterpriseId)
    {
        return tEnterpriseInfoMapper.deleteTEnterpriseInfoById(enterpriseId);
    }
}
