package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeviceInfoS;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;

/**
 * 设备信息Service业务层处理
 *
 * @author zehong
 * @date 2022-01-27
 */
@Service
public class TDeviceInfoServiceImpl implements ITDeviceInfoService
{
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备信息
     *
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    @Override
    public TDeviceInfo selectTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
    }

    /**
     * 查询设备信息列表
     *
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);
    }

    /**
     * 新增设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setCreateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.insertTDeviceInfo(tDeviceInfo);
    }

    /**
     * 修改设备信息
     *
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setUpdateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.updateTDeviceInfo(tDeviceInfo);
    }

    /**
     * 批量删除设备信息
     *
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoByIds(Long[] deviceIds)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoByIds(deviceIds);
    }

    /**
     * 删除设备信息信息
     *
     * @param deviceId 设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoById(deviceId);
    }

    /**
     * 添加关联设备信息表数据
     * @param gettDeviceInfoS
     */
    @Override
    public void insertDeviceDetailInfo(TDeviceInfoS gettDeviceInfoS) {
        tDeviceInfoMapper.insertDeviceDetailInfo(gettDeviceInfoS);
    }

    /**
     * 获取设备详细信息列表
     * @param deviceId
     * @return
     */
    @Override
    public List<TDeviceInfoS> getdeviceDetailInfo(Long deviceId) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.getdeviceDetailInfo(deviceId);
        return tDeviceInfoS;
    }

    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    @Override
    public List<TDeviceInfoS> selectDetailInfo(TDeviceInfoS tDeviceInfos) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.selectDetailInfo(tDeviceInfos);
        return tDeviceInfoS;
    }

    /**
     * 关联设备数据删除接口
     * @param deviceIds
     */
    @Override
    public void deleteDetailInfo(Long[] deviceIds) {
        tDeviceInfoMapper.deleteDetailInfo(deviceIds);
    }

    /**
     * 关联设备数据删除接口 单条删除
     * @param deviceId
     */
    @Override
    public void deleteDetailinfOS(int deviceId) {
        tDeviceInfoMapper.deleteDetailinfOS(deviceId);
    }

    /**
     * 将关联设备信息与设备进行绑定
     * @param gettDeviceInfoS
     */
    @Override
    public void updatetRelationDeviceDetailInfo(@Param("gettDeviceInfoS")List<TDeviceInfoS> gettDeviceInfoS,@Param("id") Long id,@Param("relationDevicetype") String relationDevicetype) {
        tDeviceInfoMapper.updatetRelationDeviceDetailInfo(gettDeviceInfoS,id,relationDevicetype);
    }

    /**
     * 查询设备已经关联的关联设备
     * @param id
     * @return
     */
    @Override
    public List<TDeviceInfoS> selectDetailInfoList(@Param("id") int id,@Param("relationDeviceType")String relationDeviceType) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoMapper.selectDetailInfoList(id,relationDeviceType);
        return tDeviceInfoS;
    }

    /**
     * 解绑 设备与关联设备关系
     * @param deviceId
     */
    @Override
    public void deleteDeviceDetailInfo(int deviceId) {
        tDeviceInfoMapper.deleteDeviceDetailInfo(deviceId);
    }
}
