package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.vo.HomepageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TComplainDealMapper;
import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.service.ITComplainDealService;

/**
 * 投诉处置Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-15
 */
@Service
public class TComplainDealServiceImpl implements ITComplainDealService 
{
    @Autowired
    private TComplainDealMapper tComplainDealMapper;

    /**
     * 查询投诉处置
     * 
     * @param complainDealId 投诉处置ID
     * @return 投诉处置
     */
    @Override
    public TComplainDeal selectTComplainDealById(Long complainDealId)
    {
        return tComplainDealMapper.selectTComplainDealById(complainDealId);
    }

    /**
     * 查询投诉处置列表
     * 
     * @param tComplainDeal 投诉处置
     * @return 投诉处置
     */
    @Override
    public List<TComplainDeal> selectTComplainDealList(TComplainDeal tComplainDeal)
    {
        return tComplainDealMapper.selectTComplainDealList(tComplainDeal);
    }

    /**
     * 投诉处置统计
     *
     * @return 投诉处置统计
     */
    public HomepageVo countTComplainDeal()
    {
        return tComplainDealMapper.countTComplainDeal();
    }

    /**
     * 新增投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    @Override
    public int insertTComplainDeal(TComplainDeal tComplainDeal)
    {
        tComplainDeal.setCreateTime(DateUtils.getNowDate());
        return tComplainDealMapper.insertTComplainDeal(tComplainDeal);
    }

    /**
     * 修改投诉处置
     * 
     * @param tComplainDeal 投诉处置
     * @return 结果
     */
    @Override
    public int updateTComplainDeal(TComplainDeal tComplainDeal)
    {
        tComplainDeal.setUpdateTime(DateUtils.getNowDate());
        return tComplainDealMapper.updateTComplainDeal(tComplainDeal);
    }

    /**
     * 批量删除投诉处置
     * 
     * @param complainDealIds 需要删除的投诉处置ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealByIds(Long[] complainDealIds)
    {
        return tComplainDealMapper.deleteTComplainDealByIds(complainDealIds);
    }

    /**
     * 删除投诉处置信息
     * 
     * @param complainDealId 投诉处置ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealById(Long complainDealId)
    {
        return tComplainDealMapper.deleteTComplainDealById(complainDealId);
    }
    @Override
    public  List<Map<String,Object>> selectUserByenterproseId(String enterproseId){
        return tComplainDealMapper.selectUserByenterproseId(enterproseId);
    }
}
