package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSiteStationInfo;

/**
 * 场站信息Service接口
 * 
 * @author zehong
 * @date 2022-01-27
 */
public interface ITSiteStationInfoService 
{
    /**
     * 查询场站信息
     * 
     * @param siteStationId 场站信息ID
     * @return 场站信息
     */
    public TSiteStationInfo selectTSiteStationInfoById(Long siteStationId);

    /**
     * 查询场站信息列表
     * 
     * @param tSiteStationInfo 场站信息
     * @return 场站信息集合
     */
    public List<TSiteStationInfo> selectTSiteStationInfoList(TSiteStationInfo tSiteStationInfo);

    /**
     * 新增场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    public int insertTSiteStationInfo(TSiteStationInfo tSiteStationInfo);

    /**
     * 修改场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    public int updateTSiteStationInfo(TSiteStationInfo tSiteStationInfo);

    /**
     * 批量删除场站信息
     * 
     * @param siteStationIds 需要删除的场站信息ID
     * @return 结果
     */
    public int deleteTSiteStationInfoByIds(Long[] siteStationIds);

    /**
     * 删除场站信息信息
     * 
     * @param siteStationId 场站信息ID
     * @return 结果
     */
    public int deleteTSiteStationInfoById(Long siteStationId);
}
