package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEventInfo;

/**
 * 事件处置Service接口
 * 
 * @author zehong
 * @date 2022-02-11
 */
public interface ITEventInfoService 
{
    /**
     * 查询事件处置
     * 
     * @param eventId 事件处置ID
     * @return 事件处置
     */
    public TEventInfo selectTEventInfoById(Long eventId);

    /**
     * 查询事件处置列表
     * 
     * @param tEventInfo 事件处置
     * @return 事件处置集合
     */
    public List<TEventInfo> selectTEventInfoList(TEventInfo tEventInfo);

    /**
     * 新增事件处置
     * 
     * @param tEventInfo 事件处置
     * @return 结果
     */
    public int insertTEventInfo(TEventInfo tEventInfo);

    /**
     * 修改事件处置
     * 
     * @param tEventInfo 事件处置
     * @return 结果
     */
    public int updateTEventInfo(TEventInfo tEventInfo);

    /**
     * 批量删除事件处置
     * 
     * @param eventIds 需要删除的事件处置ID
     * @return 结果
     */
    public int deleteTEventInfoByIds(Long[] eventIds);

    /**
     * 删除事件处置信息
     * 
     * @param eventId 事件处置ID
     * @return 结果
     */
    public int deleteTEventInfoById(Long eventId);
}
