package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDeviceReportData;

/**
 * 设备监控Service接口
 * 
 * @author zehong
 * @date 2022-02-16
 */
public interface ITDeviceReportDataService 
{
    /**
     * 查询设备监控
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 设备监控
     */
    public TDeviceReportData selectTDeviceReportDataById(Long deviceReportDataId);

    /**
     * 查询设备监控列表
     * 
     * @param tDeviceReportData 设备监控
     * @return 设备监控集合
     */
    public List<TDeviceReportData> selectTDeviceReportDataList(TDeviceReportData tDeviceReportData);

    /**
     * 新增设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int insertTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 修改设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int updateTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 批量删除设备监控
     * 
     * @param deviceReportDataIds 需要删除的设备监控ID
     * @return 结果
     */
    public int deleteTDeviceReportDataByIds(Long[] deviceReportDataIds);

    /**
     * 删除设备监控信息
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 结果
     */
    public int deleteTDeviceReportDataById(Long deviceReportDataId);
}
