package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 场站信息对象 t_site_station_info
 *
 * @author zehong
 * @date 2022-01-27
 */
public class TSiteStationInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 场站id */
    private Long siteStationId;

    /** 场站类型：1.加气站 2.门站 3.调压站 4.储备站 5.气化站 */
    @Excel(name = "场站类型")
    private String siteStationType;

    /** 场站名称 */
    @Excel(name = "场站名称")
    private String siteStationName;

    /** 建设年代 */
    @Excel(name = "建设年代")
    private String buildDate;

    /** 建设单位 */
    @Excel(name = "建设单位")
    private String buildUnit;

    /** 权属单位 */
    private Long beyondEnterpriseId;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 关联设备类型  1设备  2场站*/
    private String relationDeviceType;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getRelationDeviceType() {
        return relationDeviceType;
    }

    public void setRelationDeviceType(String relationDeviceType) {
        this.relationDeviceType = relationDeviceType;
    }

    public void setSiteStationId(Long siteStationId)
    {
        this.siteStationId = siteStationId;
    }

    public Long getSiteStationId()
    {
        return siteStationId;
    }
    public void setSiteStationType(String siteStationType)
    {
        this.siteStationType = siteStationType;
    }

    public String getSiteStationType()
    {
        return siteStationType;
    }
    public void setSiteStationName(String siteStationName)
    {
        this.siteStationName = siteStationName;
    }

    public String getSiteStationName()
    {
        return siteStationName;
    }
    public void setBuildDate(String buildDate)
    {
        this.buildDate = buildDate;
    }

    public String getBuildDate()
    {
        return buildDate;
    }
    public void setBuildUnit(String buildUnit)
    {
        this.buildUnit = buildUnit;
    }

    public String getBuildUnit()
    {
        return buildUnit;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TSiteStationInfo{" +
                "siteStationId=" + siteStationId +
                ", siteStationType='" + siteStationType + '\'' +
                ", siteStationName='" + siteStationName + '\'' +
                ", buildDate='" + buildDate + '\'' +
                ", buildUnit='" + buildUnit + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", relationDeviceType='" + relationDeviceType + '\'' +
                '}';
    }
}
