package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 用户加装安全装置台账对象 t_safe_equipment_standing_book
 * 
 * @author zehong
 * @date 2022-02-09
 */
public class TSafeEquipmentStandingBook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 安全装置台账id */
    private Long safeEquipmentId;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String userName;

    /** 用户编号 */
    @Excel(name = "用户编号")
    private String userNo;

    /** 用户详细地址 */
    @Excel(name = "用户详细地址")
    private String userAddress;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String linkMobile;

    /** 安装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "安装时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date installTime;

    /** 品牌名称 */
    @Excel(name = "品牌名称")
    private String brandName;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setSafeEquipmentId(Long safeEquipmentId) 
    {
        this.safeEquipmentId = safeEquipmentId;
    }

    public Long getSafeEquipmentId() 
    {
        return safeEquipmentId;
    }
    public void setUserName(String userName) 
    {
        this.userName = userName;
    }

    public String getUserName() 
    {
        return userName;
    }
    public void setUserNo(String userNo)
    {
        this.userNo = userNo;
    }

    public String getUserNo()
    {
        return userNo;
    }
    public void setUserAddress(String userAddress) 
    {
        this.userAddress = userAddress;
    }

    public String getUserAddress() 
    {
        return userAddress;
    }
    public void setIdCard(String idCard) 
    {
        this.idCard = idCard;
    }

    public String getIdCard() 
    {
        return idCard;
    }
    public void setLinkMobile(String linkMobile) 
    {
        this.linkMobile = linkMobile;
    }

    public String getLinkMobile() 
    {
        return linkMobile;
    }
    public void setInstallTime(Date installTime) 
    {
        this.installTime = installTime;
    }

    public Date getInstallTime() 
    {
        return installTime;
    }
    public void setBrandName(String brandName) 
    {
        this.brandName = brandName;
    }

    public String getBrandName() 
    {
        return brandName;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("safeEquipmentId", getSafeEquipmentId())
            .append("userName", getUserName())
            .append("userNo", getUserNo())
            .append("userAddress", getUserAddress())
            .append("idCard", getIdCard())
            .append("linkMobile", getLinkMobile())
            .append("installTime", getInstallTime())
            .append("brandName", getBrandName())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
