package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管道信息对象 t_pipe_info
 *
 * @author zehong
 * @date 2022-02-09
 */
public class TPipeInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 管道id */
    private Long pipeId;

    /** 管道长度 */
    @Excel(name = "管道长度")
    private BigDecimal pipeLength;

    /** 管径 */
    @Excel(name = "管径")
    private BigDecimal pipeDiameter;

    /** 压力 */
    @Excel(name = "压力")
    private BigDecimal pipePressure;

    /** 材质 */
    @Excel(name = "材质")
    private String pipeMaterial;

    /** 管道地址 */
    @Excel(name = "管道地址")
    private String pipeAddr;

    /** 埋深 */
    @Excel(name = "埋深")
    private BigDecimal buriedDepth;

    /** 走向 */
    @Excel(name = "走向")
    private String pipeTrend;

    /** 建设年代 */
    @Excel(name = "建设年代")
    private String buildDate;

    /** 建设单位 */
    @Excel(name = "建设单位")
    private String buildUnit;

    /**人员类型*/
    private String peopleOccupation;

    /** 权属单位 */
    @Excel(name = "权属单位")
    private Long beyondEnterpriseId;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    /** 坐标 */
    @Excel(name = "坐标")
    private String coordinates;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getPeopleOccupation() {
        return peopleOccupation;
    }

    public void setPeopleOccupation(String peopleOccupation) {
        this.peopleOccupation = peopleOccupation;
    }

    public void setPipeId(Long pipeId)
    {
        this.pipeId = pipeId;
    }

    public Long getPipeId()
    {
        return pipeId;
    }
    public void setPipeLength(BigDecimal pipeLength)
    {
        this.pipeLength = pipeLength;
    }

    public BigDecimal getPipeLength()
    {
        return pipeLength;
    }
    public void setPipeDiameter(BigDecimal pipeDiameter)
    {
        this.pipeDiameter = pipeDiameter;
    }

    public BigDecimal getPipeDiameter()
    {
        return pipeDiameter;
    }
    public void setPipePressure(BigDecimal pipePressure)
    {
        this.pipePressure = pipePressure;
    }

    public BigDecimal getPipePressure()
    {
        return pipePressure;
    }
    public void setPipeMaterial(String pipeMaterial)
    {
        this.pipeMaterial = pipeMaterial;
    }

    public String getPipeMaterial()
    {
        return pipeMaterial;
    }
    public void setPipeAddr(String pipeAddr)
    {
        this.pipeAddr = pipeAddr;
    }

    public String getPipeAddr()
    {
        return pipeAddr;
    }
    public void setBuriedDepth(BigDecimal buriedDepth)
    {
        this.buriedDepth = buriedDepth;
    }

    public BigDecimal getBuriedDepth()
    {
        return buriedDepth;
    }
    public void setPipeTrend(String pipeTrend)
    {
        this.pipeTrend = pipeTrend;
    }

    public String getPipeTrend()
    {
        return pipeTrend;
    }
    public void setBuildDate(String buildDate)
    {
        this.buildDate = buildDate;
    }

    public String getBuildDate()
    {
        return buildDate;
    }
    public void setBuildUnit(String buildUnit)
    {
        this.buildUnit = buildUnit;
    }

    public String getBuildUnit()
    {
        return buildUnit;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }
    public void setCoordinates(String coordinates)
    {
        this.coordinates = coordinates;
    }

    public String getCoordinates()
    {
        return coordinates;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TPipeInfo{" +
                "pipeId=" + pipeId +
                ", pipeLength=" + pipeLength +
                ", pipeDiameter=" + pipeDiameter +
                ", pipePressure=" + pipePressure +
                ", pipeMaterial='" + pipeMaterial + '\'' +
                ", pipeAddr='" + pipeAddr + '\'' +
                ", buriedDepth=" + buriedDepth +
                ", pipeTrend='" + pipeTrend + '\'' +
                ", buildDate='" + buildDate + '\'' +
                ", buildUnit='" + buildUnit + '\'' +
                ", peopleOccupation='" + peopleOccupation + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                ", coordinates='" + coordinates + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
